/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.ga4gh;

import ga4gh.Common;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.slf4j.Logger;

@Immutable
final class MapToGa4ghAttributes
extends AbstractConverter<Map<String, String>, Common.Attributes> {
    MapToGa4ghAttributes() {
        super(Map.class, Common.Attributes.class);
    }

    public Common.Attributes convert(Map<String, String> attributes, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (attributes == null) {
            this.warnOrThrow(attributes, "must not be null", null, stringency, logger);
            return null;
        }
        HashMap<String, Common.AttributeValueList> map = new HashMap<String, Common.AttributeValueList>();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            Common.AttributeValueList attributeValue = Common.AttributeValueList.newBuilder().addValues(Common.AttributeValue.newBuilder().setStringValue(entry.getValue())).build();
            map.put(entry.getKey(), attributeValue);
        }
        return Common.Attributes.newBuilder().putAllAttr(map).build();
    }
}

