/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.ga4gh;

import ga4gh.Common;
import ga4gh.SequenceAnnotations;
import javax.annotation.concurrent.Immutable;
import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.convert.Converter;
import org.bdgenomics.formats.avro.Feature;
import org.bdgenomics.formats.avro.Strand;
import org.slf4j.Logger;

@Immutable
final class BdgenomicsFeatureToGa4ghFeature
extends AbstractConverter<Feature, SequenceAnnotations.Feature> {
    private final Converter<String, Common.OntologyTerm> featureTypeConverter;
    private final Converter<Strand, Common.Strand> strandConverter;

    BdgenomicsFeatureToGa4ghFeature(Converter<String, Common.OntologyTerm> featureTypeConverter, Converter<Strand, Common.Strand> strandConverter) {
        super(Feature.class, SequenceAnnotations.Feature.class);
        this.checkNotNull(featureTypeConverter);
        this.checkNotNull(strandConverter);
        this.featureTypeConverter = featureTypeConverter;
        this.strandConverter = strandConverter;
    }

    public SequenceAnnotations.Feature convert(Feature feature, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (feature == null) {
            this.warnOrThrow(feature, "must not be null", null, stringency, logger);
            return null;
        }
        return SequenceAnnotations.Feature.newBuilder().setStart(feature.getStart().longValue()).setEnd(feature.getEnd().longValue()).setStrand((Common.Strand)this.strandConverter.convert((Object)feature.getStrand(), stringency, logger)).setReferenceName(feature.getContigName()).setFeatureType((Common.OntologyTerm)this.featureTypeConverter.convert((Object)feature.getFeatureType(), stringency, logger)).build();
    }
}

