/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.ga4gh;

import ga4gh.Variants;
import java.util.Arrays;
import javax.annotation.concurrent.Immutable;
import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.formats.avro.Variant;
import org.slf4j.Logger;

@Immutable
public class BdgenomicsVariantToGa4ghVariant
extends AbstractConverter<Variant, Variants.Variant> {
    BdgenomicsVariantToGa4ghVariant() {
        super(Variant.class, Variants.Variant.class);
    }

    public Variants.Variant convert(Variant variant, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (variant == null) {
            this.warnOrThrow(variant, "must not be null", null, stringency, logger);
            return null;
        }
        return Variants.Variant.newBuilder().addAllNames((Iterable)variant.getNames()).setReferenceName(variant.getContigName()).setStart(variant.getStart().longValue()).setEnd(variant.getEnd().longValue()).setReferenceBases(variant.getReferenceAllele()).addAllAlternateBases(Arrays.asList(variant.getAlternateAllele())).addAllFiltersFailed((Iterable)variant.getFiltersFailed()).setFiltersPassed(variant.getFiltersPassed().booleanValue()).setFiltersApplied(variant.getFiltersApplied().booleanValue()).build();
    }
}

