/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.ga4gh;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import ga4gh.Common;
import ga4gh.Reads;
import ga4gh.SequenceAnnotations;
import ga4gh.Variants;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarOperator;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.bdgenomics.convert.Converter;
import org.bdgenomics.convert.ga4gh.AlignmentRecordToReadAlignment;
import org.bdgenomics.convert.ga4gh.BdgenomicsFeatureToGa4ghFeature;
import org.bdgenomics.convert.ga4gh.BdgenomicsGenotypeToGa4ghCall;
import org.bdgenomics.convert.ga4gh.BdgenomicsOntologyTermToGa4ghOntologyTerm;
import org.bdgenomics.convert.ga4gh.BdgenomicsStrandToGa4ghStrand;
import org.bdgenomics.convert.ga4gh.BdgenomicsVariantToGa4ghVariant;
import org.bdgenomics.convert.ga4gh.CigarOperatorToOperation;
import org.bdgenomics.convert.ga4gh.CigarToCigarUnits;
import org.bdgenomics.convert.ga4gh.Ga4ghOntologyTermToBdgenomicsOntologyTerm;
import org.bdgenomics.convert.ga4gh.Ga4ghStrandToBdgenomicsStrand;
import org.bdgenomics.convert.ga4gh.GenotypeAlleleToString;
import org.bdgenomics.convert.ga4gh.StringToOntologyTerm;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.bdgenomics.formats.avro.Feature;
import org.bdgenomics.formats.avro.Genotype;
import org.bdgenomics.formats.avro.GenotypeAllele;
import org.bdgenomics.formats.avro.OntologyTerm;
import org.bdgenomics.formats.avro.Strand;
import org.bdgenomics.formats.avro.Variant;

@Immutable
public final class Ga4ghModule
extends AbstractModule {
    protected void configure() {
    }

    @Provides
    @Singleton
    Converter<CigarOperator, Reads.CigarUnit.Operation> createCigarOperatorToOperation() {
        return new CigarOperatorToOperation();
    }

    @Provides
    @Singleton
    Converter<Cigar, List<Reads.CigarUnit>> createCigarToCigarUnits(Converter<CigarOperator, Reads.CigarUnit.Operation> operatorConverter) {
        return new CigarToCigarUnits(operatorConverter);
    }

    @Provides
    @Singleton
    Converter<GenotypeAllele, String> createGenotyepAlleleToString() {
        return new GenotypeAlleleToString();
    }

    @Provides
    @Singleton
    Converter<AlignmentRecord, Reads.ReadAlignment> createAlignmentRecordToReadAlignment(Converter<Cigar, List<Reads.CigarUnit>> cigarConverter) {
        return new AlignmentRecordToReadAlignment(cigarConverter);
    }

    @Provides
    @Singleton
    Converter<Variant, Variants.Variant> createBdgenomicsVariantToGa4ghVariant() {
        return new BdgenomicsVariantToGa4ghVariant();
    }

    @Provides
    @Singleton
    Converter<Genotype, Variants.Call> createBdgenomicsGenotypeToGa4ghCall(Converter<GenotypeAllele, String> genotypeAlleleConverter) {
        return new BdgenomicsGenotypeToGa4ghCall(genotypeAlleleConverter);
    }

    @Provides
    @Singleton
    Converter<Common.Strand, Strand> createGa4ghStrandToBdgenomicsStrand() {
        return new Ga4ghStrandToBdgenomicsStrand();
    }

    @Provides
    @Singleton
    Converter<Strand, Common.Strand> createBdgenomicsStrandToGa4ghStrand() {
        return new BdgenomicsStrandToGa4ghStrand();
    }

    @Provides
    @Singleton
    Converter<Common.OntologyTerm, OntologyTerm> createGa4ghOntologyTermToBdgenomicsOntologyTerm() {
        return new Ga4ghOntologyTermToBdgenomicsOntologyTerm();
    }

    @Provides
    @Singleton
    Converter<String, Common.OntologyTerm> createFeatureTypeToOntologyTerm() {
        return new StringToOntologyTerm();
    }

    @Provides
    @Singleton
    Converter<OntologyTerm, Common.OntologyTerm> createBdgenomicsOntologyTermToGa4ghOntologyTerm() {
        return new BdgenomicsOntologyTermToGa4ghOntologyTerm();
    }

    @Provides
    @Singleton
    Converter<Feature, SequenceAnnotations.Feature> createBdgenomicsFeatureToGa4ghFeature(Converter<String, Common.OntologyTerm> featureTypeConverter, Converter<Strand, Common.Strand> strandConverter) {
        return new BdgenomicsFeatureToGa4ghFeature(featureTypeConverter, strandConverter);
    }
}

