/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.ga4gh;

import ga4gh.Common;
import javax.annotation.concurrent.Immutable;
import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.formats.avro.Strand;
import org.slf4j.Logger;

@Immutable
final class Ga4ghStrandToBdgenomicsStrand
extends AbstractConverter<Common.Strand, Strand> {
    Ga4ghStrandToBdgenomicsStrand() {
        super(Common.Strand.class, Strand.class);
    }

    public Strand convert(Common.Strand strand, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (strand == null) {
            this.warnOrThrow(strand, "must not be null", null, stringency, logger);
            return null;
        }
        if (strand.equals((Object)Common.Strand.POS_STRAND)) {
            return Strand.FORWARD;
        }
        if (strand.equals((Object)Common.Strand.NEG_STRAND)) {
            return Strand.REVERSE;
        }
        if (strand.equals((Object)Common.Strand.UNRECOGNIZED)) {
            return Strand.INDEPENDENT;
        }
        return Strand.UNKNOWN;
    }
}

