/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.ga4gh;

import ga4gh.Variants;
import java.util.Arrays;
import javax.annotation.concurrent.Immutable;
import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.formats.avro.Variant;
import org.slf4j.Logger;

@Immutable
public class BdgenomicsVariantToGa4ghVariant
extends AbstractConverter<Variant, Variants.Variant> {
    BdgenomicsVariantToGa4ghVariant() {
        super(Variant.class, Variants.Variant.class);
    }

    public Variants.Variant convert(Variant variant, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (variant == null) {
            this.warnOrThrow(variant, "must not be null", null, stringency, logger);
            return null;
        }
        Variants.Variant.Builder builder = Variants.Variant.newBuilder();
        if (variant.getNames() != null && !variant.getNames().isEmpty()) {
            builder.addAllNames((Iterable)variant.getNames());
        }
        if (variant.getContigName() != null) {
            builder.setReferenceName(variant.getContigName());
        }
        if (variant.getStart() != null) {
            builder.setStart(variant.getStart().longValue());
        }
        if (variant.getEnd() != null) {
            builder.setEnd(variant.getEnd().longValue());
        }
        if (variant.getReferenceAllele() != null) {
            builder.setReferenceBases(variant.getReferenceAllele());
        }
        if (variant.getAlternateAllele() != null) {
            builder.addAllAlternateBases(Arrays.asList(variant.getAlternateAllele()));
        }
        if (variant.getFiltersFailed() != null && !variant.getFiltersFailed().isEmpty()) {
            builder.addAllFiltersFailed((Iterable)variant.getFiltersFailed());
        }
        if (variant.getFiltersPassed() != null) {
            builder.setFiltersPassed(variant.getFiltersPassed().booleanValue());
        }
        if (variant.getFiltersApplied() != null) {
            builder.setFiltersPassed(variant.getFiltersApplied().booleanValue());
        }
        return builder.build();
    }
}

