/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.ga4gh;

import ga4gh.Common;
import ga4gh.Reads;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.convert.Converter;
import org.bdgenomics.formats.avro.ProcessingStep;
import org.bdgenomics.formats.avro.RecordGroup;
import org.slf4j.Logger;

@Immutable
final class ReadGroupToRecordGroup
extends AbstractConverter<Reads.ReadGroup, RecordGroup> {
    private final Converter<Common.Program, ProcessingStep> programConverter;

    ReadGroupToRecordGroup(Converter<Common.Program, ProcessingStep> programConverter) {
        super(Reads.ReadGroup.class, RecordGroup.class);
        this.checkNotNull(programConverter);
        this.programConverter = programConverter;
    }

    public RecordGroup convert(Reads.ReadGroup readGroup, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (readGroup == null) {
            this.warnOrThrow(readGroup, "must not be null", null, stringency, logger);
            return null;
        }
        RecordGroup.Builder builder = RecordGroup.newBuilder().setName(readGroup.getName()).setSample(readGroup.getSampleName()).setDescription(readGroup.getDescription()).setPredictedMedianInsertSize(Integer.valueOf(readGroup.getPredictedInsertSize()));
        List programs = readGroup.getProgramsList();
        if (!programs.isEmpty()) {
            ArrayList<Object> processingSteps = new ArrayList<Object>(programs.size());
            for (Common.Program program : programs) {
                processingSteps.add(this.programConverter.convert((Object)program, stringency, logger));
            }
            builder.setProcessingSteps(processingSteps);
        }
        return builder.build();
    }
}

