/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.ga4gh;

import ga4gh.Common;
import ga4gh.Reads;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.convert.Converter;
import org.bdgenomics.formats.avro.ProcessingStep;
import org.bdgenomics.formats.avro.RecordGroup;
import org.slf4j.Logger;

@Immutable
final class RecordGroupToReadGroup
extends AbstractConverter<RecordGroup, Reads.ReadGroup> {
    private final Converter<ProcessingStep, Common.Program> processingStepConverter;

    RecordGroupToReadGroup(Converter<ProcessingStep, Common.Program> processingStepConverter) {
        super(RecordGroup.class, Reads.ReadGroup.class);
        this.checkNotNull(processingStepConverter);
        this.processingStepConverter = processingStepConverter;
    }

    public Reads.ReadGroup convert(RecordGroup recordGroup, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (recordGroup == null) {
            this.warnOrThrow(recordGroup, "must not be null", null, stringency, logger);
            return null;
        }
        Reads.ReadGroup.Builder builder = Reads.ReadGroup.newBuilder().setId(StringUtils.isNotEmpty((CharSequence)recordGroup.getName()) ? recordGroup.getName() : "1").setName(StringUtils.isNotEmpty((CharSequence)recordGroup.getName()) ? recordGroup.getName() : "1");
        if (StringUtils.isNotEmpty((CharSequence)recordGroup.getSample())) {
            builder.setSampleName(recordGroup.getSample());
        }
        if (StringUtils.isNotEmpty((CharSequence)recordGroup.getDescription())) {
            builder.setDescription(recordGroup.getDescription());
        }
        if (recordGroup.getPredictedMedianInsertSize() != null) {
            builder.setPredictedInsertSize(recordGroup.getPredictedMedianInsertSize().intValue());
        }
        if (!recordGroup.getProcessingSteps().isEmpty()) {
            for (ProcessingStep processingStep : recordGroup.getProcessingSteps()) {
                builder.addPrograms((Common.Program)this.processingStepConverter.convert((Object)processingStep, stringency, logger));
            }
        }
        return builder.build();
    }
}

