/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.ga4gh;

import ga4gh.Common;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.slf4j.Logger;

@Immutable
final class Ga4ghAttributesToMap
extends AbstractConverter<Common.Attributes, Map<String, String>> {
    Ga4ghAttributesToMap() {
        super(Common.Attributes.class, Map.class);
    }

    public Map<String, String> convert(Common.Attributes attributes, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (attributes == null) {
            this.warnOrThrow(attributes, "must not be null", null, stringency, logger);
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry entry : attributes.getAttr().entrySet()) {
            String attributeValue = ((Common.AttributeValueList)entry.getValue()).getValues(0).getStringValue();
            map.put((String)entry.getKey(), attributeValue);
        }
        return map;
    }
}

