/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.ga4gh;

import ga4gh.Common;
import ga4gh.Reads;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.TextCigarCodec;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.convert.Converter;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.slf4j.Logger;

@Immutable
final class AlignmentRecordToReadAlignment
extends AbstractConverter<AlignmentRecord, Reads.ReadAlignment> {
    private final Converter<Cigar, List<Reads.CigarUnit>> cigarConverter;

    AlignmentRecordToReadAlignment(Converter<Cigar, List<Reads.CigarUnit>> cigarConverter) {
        super(AlignmentRecord.class, Reads.ReadAlignment.class);
        this.checkNotNull(cigarConverter);
        this.cigarConverter = cigarConverter;
    }

    public Reads.ReadAlignment convert(AlignmentRecord alignmentRecord, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (alignmentRecord == null) {
            this.warnOrThrow(alignmentRecord, "must not be null", null, stringency, logger);
            return null;
        }
        Reads.ReadAlignment.Builder builder = Reads.ReadAlignment.newBuilder().setAlignedSequence(alignmentRecord.getSequence()).setDuplicateFragment(alignmentRecord.getDuplicateRead().booleanValue()).setFailedVendorQualityChecks(alignmentRecord.getFailedVendorQualityChecks().booleanValue()).setFragmentName(alignmentRecord.getReadName()).setImproperPlacement(alignmentRecord.getProperPair() == false).setNumberReads(alignmentRecord.getReadPaired() != false ? 2 : 1).setReadGroupId(StringUtils.isNotEmpty((CharSequence)alignmentRecord.getReadGroupId()) ? alignmentRecord.getReadGroupId() : "1").setReadNumber(alignmentRecord.getReadInFragment().intValue()).setSecondaryAlignment(alignmentRecord.getSecondaryAlignment().booleanValue()).setSupplementaryAlignment(alignmentRecord.getSupplementaryAlignment().booleanValue());
        if (alignmentRecord.getInsertSize() != null) {
            builder.setFragmentLength(alignmentRecord.getInsertSize().intValue());
        }
        if (alignmentRecord.getMateReferenceName() != null) {
            Common.Position matePosition = Common.Position.newBuilder().setReferenceName(alignmentRecord.getMateReferenceName()).setPosition(alignmentRecord.getMateAlignmentStart().longValue()).setStrand(alignmentRecord.getMateNegativeStrand() != false ? Common.Strand.NEG_STRAND : Common.Strand.POS_STRAND).build();
            builder.setNextMatePosition(matePosition);
        }
        if (StringUtils.isNotEmpty((CharSequence)alignmentRecord.getQualityScores())) {
            ArrayList<Integer> alignedQuality = new ArrayList<Integer>(alignmentRecord.getQualityScores().length());
            for (char c : alignmentRecord.getQualityScores().toCharArray()) {
                alignedQuality.add(c - 33);
            }
            builder.addAllAlignedQuality(alignedQuality);
        }
        if (alignmentRecord.getReadMapped().booleanValue()) {
            Common.Position position = Common.Position.newBuilder().setReferenceName(alignmentRecord.getReferenceName()).setPosition(alignmentRecord.getStart().longValue()).setStrand(alignmentRecord.getReadNegativeStrand() != false ? Common.Strand.NEG_STRAND : Common.Strand.POS_STRAND).build();
            Reads.LinearAlignment.Builder alignmentBuilder = Reads.LinearAlignment.newBuilder().setPosition(position);
            if (alignmentRecord.getMappingQuality() != null) {
                alignmentBuilder.setMappingQuality(alignmentRecord.getMappingQuality().intValue());
            }
            Cigar cigar = null;
            try {
                cigar = TextCigarCodec.decode((String)alignmentRecord.getCigar());
            }
            catch (RuntimeException e) {
                this.warnOrThrow(alignmentRecord, "could not decode cigar, caught " + e.getMessage(), e, stringency, logger);
            }
            if (cigar != null) {
                alignmentBuilder.addAllCigar((Iterable)this.cigarConverter.convert((Object)cigar, stringency, logger));
            }
            builder.setAlignment(alignmentBuilder.build());
        }
        return builder.build();
    }
}

