/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.ga4gh;

import ga4gh.Common;
import javax.annotation.concurrent.Immutable;
import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.formats.avro.Strand;
import org.slf4j.Logger;

@Immutable
final class BdgenomicsStrandToGa4ghStrand
extends AbstractConverter<Strand, Common.Strand> {
    BdgenomicsStrandToGa4ghStrand() {
        super(Strand.class, Common.Strand.class);
    }

    public Common.Strand convert(Strand strand, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (strand == null) {
            this.warnOrThrow(strand, "must not be null", null, stringency, logger);
            return null;
        }
        if (strand.equals((Object)Strand.FORWARD)) {
            return Common.Strand.POS_STRAND;
        }
        if (strand.equals((Object)Strand.REVERSE)) {
            return Common.Strand.NEG_STRAND;
        }
        if (strand.equals((Object)Strand.INDEPENDENT)) {
            return Common.Strand.UNRECOGNIZED;
        }
        return Common.Strand.STRAND_UNSPECIFIED;
    }
}

