/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.ga4gh;

import ga4gh.Reads;
import htsjdk.samtools.CigarOperator;
import javax.annotation.concurrent.Immutable;
import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.slf4j.Logger;

@Immutable
final class CigarOperatorToOperation
extends AbstractConverter<CigarOperator, Reads.CigarUnit.Operation> {
    CigarOperatorToOperation() {
        super(CigarOperator.class, Reads.CigarUnit.Operation.class);
    }

    public Reads.CigarUnit.Operation convert(CigarOperator cigarOperator, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (cigarOperator == null) {
            this.warnOrThrow(cigarOperator, "must not be null", null, stringency, logger);
            return null;
        }
        switch (cigarOperator) {
            case M: {
                return Reads.CigarUnit.Operation.ALIGNMENT_MATCH;
            }
            case I: {
                return Reads.CigarUnit.Operation.INSERT;
            }
            case D: {
                return Reads.CigarUnit.Operation.DELETE;
            }
            case N: {
                return Reads.CigarUnit.Operation.SKIP;
            }
            case S: {
                return Reads.CigarUnit.Operation.CLIP_SOFT;
            }
            case H: {
                return Reads.CigarUnit.Operation.CLIP_HARD;
            }
            case P: {
                return Reads.CigarUnit.Operation.PAD;
            }
            case EQ: {
                return Reads.CigarUnit.Operation.SEQUENCE_MATCH;
            }
            case X: {
                return Reads.CigarUnit.Operation.SEQUENCE_MISMATCH;
            }
        }
        this.warnOrThrow(cigarOperator, "could not match operator", null, stringency, logger);
        return null;
    }
}

