/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.ga4gh;

import ga4gh.Common;
import javax.annotation.concurrent.Immutable;
import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.formats.avro.ProcessingStep;
import org.slf4j.Logger;

@Immutable
final class ProgramToProcessingStep
extends AbstractConverter<Common.Program, ProcessingStep> {
    ProgramToProcessingStep() {
        super(Common.Program.class, ProcessingStep.class);
    }

    public ProcessingStep convert(Common.Program program, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (program == null) {
            this.warnOrThrow(program, "must not be null", null, stringency, logger);
            return null;
        }
        return ProcessingStep.newBuilder().setId(program.getId()).setProgramName(program.getName()).setCommandLine(program.getCommandLine()).setPreviousId(program.getPrevProgramId()).setVersion(program.getVersion()).build();
    }
}

