/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.htsjdk;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMProgramRecord;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.ValidationStringency;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import java.util.List;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.convert.Converter;
import org.bdgenomics.convert.htsjdk.AlignmentToSamRecord;
import org.bdgenomics.convert.htsjdk.AlignmentToSamRecordFactory;
import org.bdgenomics.convert.htsjdk.ConversionStringencyToValidationStringency;
import org.bdgenomics.convert.htsjdk.GenotypesToVariantContext;
import org.bdgenomics.convert.htsjdk.GenotypesToVariantContextFactory;
import org.bdgenomics.convert.htsjdk.SamHeaderToProcessingSteps;
import org.bdgenomics.convert.htsjdk.SamHeaderToReadGroups;
import org.bdgenomics.convert.htsjdk.SamHeaderToReferences;
import org.bdgenomics.convert.htsjdk.SamProgramRecordToProcessingStep;
import org.bdgenomics.convert.htsjdk.SamReadGroupRecordToReadGroup;
import org.bdgenomics.convert.htsjdk.SamRecordToAlignment;
import org.bdgenomics.convert.htsjdk.SamSequenceRecordToReference;
import org.bdgenomics.convert.htsjdk.ValidationStringencyToConversionStringency;
import org.bdgenomics.convert.htsjdk.VariantContextToGenotypes;
import org.bdgenomics.convert.htsjdk.VariantContextToGenotypesFactory;
import org.bdgenomics.convert.htsjdk.VariantContextToVariants;
import org.bdgenomics.convert.htsjdk.VariantContextToVariantsFactory;
import org.bdgenomics.convert.htsjdk.VariantToVariantContext;
import org.bdgenomics.convert.htsjdk.VariantToVariantContextFactory;
import org.bdgenomics.convert.htsjdk.VcfHeaderToReferences;
import org.bdgenomics.convert.htsjdk.VcfHeaderToSamples;
import org.bdgenomics.convert.htsjdk.VcfHeaderToVcfHeaderLines;
import org.bdgenomics.formats.avro.Alignment;
import org.bdgenomics.formats.avro.Genotype;
import org.bdgenomics.formats.avro.ProcessingStep;
import org.bdgenomics.formats.avro.ReadGroup;
import org.bdgenomics.formats.avro.Reference;
import org.bdgenomics.formats.avro.Sample;
import org.bdgenomics.formats.avro.Variant;

public final class HtsjdkModule
extends AbstractModule {
    protected void configure() {
        this.install(new FactoryModuleBuilder().implement((TypeLiteral)new TypeLiteral<Converter<Alignment, SAMRecord>>(){}, AlignmentToSamRecord.class).build(AlignmentToSamRecordFactory.class));
        this.install(new FactoryModuleBuilder().implement((TypeLiteral)new TypeLiteral<Converter<List<Genotype>, VariantContext>>(){}, GenotypesToVariantContext.class).build(GenotypesToVariantContextFactory.class));
        this.install(new FactoryModuleBuilder().implement((TypeLiteral)new TypeLiteral<Converter<Variant, VariantContext>>(){}, VariantToVariantContext.class).build(VariantToVariantContextFactory.class));
        this.install(new FactoryModuleBuilder().implement((TypeLiteral)new TypeLiteral<Converter<VariantContext, List<Genotype>>>(){}, VariantContextToGenotypes.class).build(VariantContextToGenotypesFactory.class));
        this.install(new FactoryModuleBuilder().implement((TypeLiteral)new TypeLiteral<Converter<VariantContext, List<Variant>>>(){}, VariantContextToVariants.class).build(VariantContextToVariantsFactory.class));
    }

    @Provides
    @Singleton
    Converter<ConversionStringency, ValidationStringency> createConversionStringencyToValidationStringency() {
        return new ConversionStringencyToValidationStringency();
    }

    @Provides
    @Singleton
    Converter<ValidationStringency, ConversionStringency> createValidationStringencyToConversionStringency() {
        return new ValidationStringencyToConversionStringency();
    }

    @Provides
    @Singleton
    Converter<SAMRecord, Alignment> createSamRecordToAlignment() {
        return new SamRecordToAlignment();
    }

    @Provides
    @Singleton
    Converter<SAMSequenceRecord, Reference> createSamSequenceRecordToReference() {
        return new SamSequenceRecordToReference();
    }

    @Provides
    @Singleton
    Converter<SAMFileHeader, List<Reference>> createSamHeaderToReferences(Converter<SAMSequenceRecord, Reference> referenceConverter) {
        return new SamHeaderToReferences(referenceConverter);
    }

    @Provides
    @Singleton
    Converter<SAMReadGroupRecord, ReadGroup> createSamReadGroupRecordToReadGroups() {
        return new SamReadGroupRecordToReadGroup();
    }

    @Provides
    @Singleton
    Converter<SAMFileHeader, List<ReadGroup>> createSamHeaderToReadGroups(Converter<SAMReadGroupRecord, ReadGroup> readGroupConverter) {
        return new SamHeaderToReadGroups(readGroupConverter);
    }

    @Provides
    @Singleton
    Converter<SAMProgramRecord, ProcessingStep> createSamProgramRecordToProcessingStep() {
        return new SamProgramRecordToProcessingStep();
    }

    @Provides
    @Singleton
    Converter<SAMFileHeader, List<ProcessingStep>> createSamHeaderToProcessingSteps(Converter<SAMProgramRecord, ProcessingStep> processingStepConverter) {
        return new SamHeaderToProcessingSteps(processingStepConverter);
    }

    @Provides
    @Singleton
    Converter<VCFHeader, List<Reference>> createVcfHeaderToReferences(Converter<SAMSequenceRecord, Reference> referenceConverter) {
        return new VcfHeaderToReferences(referenceConverter);
    }

    @Provides
    @Singleton
    Converter<VCFHeader, List<Sample>> createVcfHeaderToSamples() {
        return new VcfHeaderToSamples();
    }

    @Provides
    @Singleton
    Converter<VCFHeader, List<VCFHeaderLine>> createVcfHeaderToVcfHeaderLines() {
        return new VcfHeaderToVcfHeaderLines();
    }
}

