/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.htsjdk;

import htsjdk.samtools.SAMReadGroupRecord;
import java.util.Optional;
import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.formats.avro.ReadGroup;
import org.slf4j.Logger;

public final class SamReadGroupRecordToReadGroup
extends AbstractConverter<SAMReadGroupRecord, ReadGroup> {
    public SamReadGroupRecordToReadGroup() {
        super(SAMReadGroupRecord.class, ReadGroup.class);
    }

    public ReadGroup convert(SAMReadGroupRecord record, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (record == null) {
            this.warnOrThrow(record, "must not be null", null, stringency, logger);
            return null;
        }
        if (record.getReadGroupId() == null) {
            this.warnOrThrow(record, "readGroupId must not be null", null, stringency, logger);
            return null;
        }
        if (record.getSample() == null) {
            this.warnOrThrow(record, "sample must not be null", null, stringency, logger);
            return null;
        }
        ReadGroup.Builder builder = ReadGroup.newBuilder().setId(record.getReadGroupId()).setSampleId(record.getSample());
        Optional.ofNullable(record.getDescription()).ifPresent(description -> builder.setDescription(description));
        Optional.ofNullable(record.getFlowOrder()).ifPresent(flowOrder -> builder.setFlowOrder(flowOrder));
        Optional.ofNullable(record.getKeySequence()).ifPresent(keySequence -> builder.setKeySequence(keySequence));
        Optional.ofNullable(record.getLibrary()).ifPresent(library -> builder.setLibrary(library));
        Optional.ofNullable(record.getPlatform()).ifPresent(platform -> builder.setPlatform(platform));
        Optional.ofNullable(record.getPlatformModel()).ifPresent(platformModel -> builder.setPlatformModel(platformModel));
        Optional.ofNullable(record.getPlatformUnit()).ifPresent(platformUnit -> builder.setPlatformUnit(platformUnit));
        Optional.ofNullable(record.getPredictedMedianInsertSize()).ifPresent(insertSize -> builder.setPredictedMedianInsertSize(insertSize));
        Optional.ofNullable(record.getRunDate()).map(runDate -> builder.setRunDateEpoch(Long.valueOf(runDate.getTime())));
        Optional.ofNullable(record.getSequencingCenter()).ifPresent(sequencingCenter -> builder.setSequencingCenter(sequencingCenter));
        return builder.build();
    }
}

