/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.htsjdk;

import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import java.util.ArrayList;
import java.util.List;
import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.slf4j.Logger;

public final class VcfHeaderToVcfHeaderLines
extends AbstractConverter<VCFHeader, List<VCFHeaderLine>> {
    public VcfHeaderToVcfHeaderLines() {
        super(VCFHeader.class, VCFHeaderLine.class);
    }

    public List<VCFHeaderLine> convert(VCFHeader header, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (header == null) {
            this.warnOrThrow(header, "must not be null", null, stringency, logger);
            return null;
        }
        ArrayList<VCFHeaderLine> headerLines = new ArrayList<VCFHeaderLine>();
        headerLines.addAll(header.getFilterLines());
        headerLines.addAll(header.getFormatHeaderLines());
        headerLines.addAll(header.getInfoHeaderLines());
        headerLines.addAll(header.getOtherHeaderLines());
        return headerLines;
    }
}

