/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.htsjdk;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMProgramRecord;
import java.util.ArrayList;
import java.util.List;
import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.convert.Converter;
import org.bdgenomics.convert.htsjdk.SamProgramRecordToProcessingStep;
import org.bdgenomics.formats.avro.ProcessingStep;
import org.slf4j.Logger;

public final class SamHeaderToProcessingSteps
extends AbstractConverter<SAMFileHeader, List<ProcessingStep>> {
    private final Converter<SAMProgramRecord, ProcessingStep> processingStepConverter;

    public SamHeaderToProcessingSteps() {
        this((Converter<SAMProgramRecord, ProcessingStep>)new SamProgramRecordToProcessingStep());
    }

    SamHeaderToProcessingSteps(Converter<SAMProgramRecord, ProcessingStep> processingStepConverter) {
        super(SAMProgramRecord.class, ProcessingStep.class);
        this.checkNotNull(processingStepConverter);
        this.processingStepConverter = processingStepConverter;
    }

    public List<ProcessingStep> convert(SAMFileHeader header, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (header == null) {
            this.warnOrThrow(header, "must not be null", null, stringency, logger);
            return null;
        }
        ArrayList<ProcessingStep> processingSteps = new ArrayList<ProcessingStep>();
        if (header.getProgramRecords() != null) {
            for (SAMProgramRecord record : header.getProgramRecords()) {
                processingSteps.add((ProcessingStep)this.processingStepConverter.convert((Object)record, stringency, logger));
            }
        }
        return processingSteps;
    }
}

