/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.htsjdk;

import htsjdk.samtools.SAMBinaryTagAndValue;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.TextTagCodec;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.formats.avro.Alignment;
import org.slf4j.Logger;

public final class SamRecordToAlignment
extends AbstractConverter<SAMRecord, Alignment> {
    private static final Pattern FIRST_CIGAR_OPERATION = Pattern.compile("^([0-9]*)([A-Z]).*$");
    private static final Pattern LAST_CIGAR_OPERATION = Pattern.compile("^.*([0-9]*)([A-Z])$");
    private static final TextTagCodec TAG_CODEC = new TextTagCodec();

    public SamRecordToAlignment() {
        super(SAMRecord.class, Alignment.class);
    }

    public Alignment convert(SAMRecord samRecord, ConversionStringency stringency, Logger logger) throws ConversionException {
        String attributes;
        String md;
        SAMReadGroupRecord readGroup;
        long insertSize;
        int readReference;
        if (samRecord == null) {
            this.warnOrThrow(samRecord, "must not be null", null, stringency, logger);
            return null;
        }
        Alignment.Builder builder = Alignment.newBuilder().setReadName(samRecord.getReadName()).setSequence(samRecord.getReadString());
        String cigar = samRecord.getCigarString();
        if (cigar != null && !"*".equals(cigar)) {
            builder.setCigar(cigar);
            builder.setBasesTrimmedFromStart(Integer.valueOf(SamRecordToAlignment.startTrim(cigar)));
            builder.setBasesTrimmedFromEnd(Integer.valueOf(SamRecordToAlignment.endTrim(cigar)));
        }
        if (samRecord.getBaseQualityString() != "*") {
            builder.setQualityScores(samRecord.getBaseQualityString());
        }
        if (samRecord.getOriginalBaseQualities() != null) {
            builder.setOriginalQualityScores(SAMUtils.phredToFastq((byte[])samRecord.getOriginalBaseQualities()));
        }
        if ((readReference = samRecord.getReferenceIndex().intValue()) != -1) {
            builder.setReferenceName(samRecord.getReferenceName());
            long start = samRecord.getAlignmentStart();
            if (start < 1L) {
                this.warnOrThrow(samRecord, "alignment start must be greater than zero if read aligned", null, stringency, logger);
            } else {
                builder.setStart(Long.valueOf(start - 1L));
                long end = start - 1L + (long)samRecord.getCigar().getReferenceLength();
                builder.setEnd(Long.valueOf(end));
            }
            int mappingQuality = samRecord.getMappingQuality();
            if (mappingQuality != 255) {
                builder.setMappingQuality(Integer.valueOf(mappingQuality));
            }
            if (samRecord.getAttribute("OP") != null) {
                builder.setOriginalStart(Long.valueOf((long)samRecord.getIntegerAttribute("OP").intValue() - 1L));
                builder.setOriginalCigar(samRecord.getStringAttribute("OC"));
            }
        }
        builder.setReadMapped(Boolean.valueOf(!samRecord.getReadUnmappedFlag()));
        builder.setReadNegativeStrand(Boolean.valueOf(samRecord.getReadNegativeStrandFlag()));
        builder.setPrimaryAlignment(Boolean.valueOf(!samRecord.getNotPrimaryAlignmentFlag()));
        builder.setSupplementaryAlignment(Boolean.valueOf(samRecord.getSupplementaryAlignmentFlag()));
        int mateReferenceIndex = samRecord.getMateReferenceIndex();
        if (mateReferenceIndex != -1) {
            builder.setMateReferenceName(samRecord.getMateReferenceName());
            long mateStart = samRecord.getMateAlignmentStart();
            if (mateStart < 1L) {
                this.warnOrThrow(samRecord, "mate start must be greater than zero if mate aligned", null, stringency, logger);
            } else {
                builder.setMateAlignmentStart(Long.valueOf(mateStart - 1L));
            }
        }
        if (samRecord.getFlags() != 0) {
            if (samRecord.getReadPairedFlag()) {
                builder.setReadPaired(Boolean.valueOf(true));
                if (samRecord.getMateNegativeStrandFlag()) {
                    builder.setMateNegativeStrand(Boolean.valueOf(true));
                }
                if (!samRecord.getMateUnmappedFlag()) {
                    builder.setMateMapped(Boolean.valueOf(true));
                }
                if (samRecord.getProperPairFlag()) {
                    builder.setProperPair(Boolean.valueOf(true));
                }
                if (samRecord.getFirstOfPairFlag()) {
                    builder.setReadInFragment(Integer.valueOf(0));
                }
                if (samRecord.getSecondOfPairFlag()) {
                    builder.setReadInFragment(Integer.valueOf(1));
                }
            }
            if (samRecord.getDuplicateReadFlag()) {
                builder.setDuplicateRead(Boolean.valueOf(true));
            }
            if (samRecord.getReadFailsVendorQualityCheckFlag()) {
                builder.setFailedVendorQualityChecks(Boolean.valueOf(true));
            }
        }
        if ((insertSize = (long)samRecord.getInferredInsertSize()) != 0L) {
            builder.setInsertSize(Long.valueOf(insertSize));
        }
        if ((readGroup = samRecord.getReadGroup()) != null) {
            builder.setReadGroupId(readGroup.getReadGroupId());
            builder.setReadGroupSampleId(readGroup.getSample());
        }
        if ((md = samRecord.getStringAttribute("MD")) != null) {
            builder.setMismatchingPositions(md);
        }
        if (!(attributes = SamRecordToAlignment.encodeAttributes(SamRecordToAlignment.getBinaryAttributes(samRecord))).isEmpty()) {
            builder.setAttributes(attributes);
        }
        return builder.build();
    }

    static int startTrim(String cigar) {
        String operator;
        int startTrim = 0;
        Matcher m = FIRST_CIGAR_OPERATION.matcher(cigar);
        if (m.matches() && "H".equals(operator = m.group(2))) {
            startTrim = Integer.parseInt(m.group(1));
        }
        return startTrim;
    }

    static int endTrim(String cigar) {
        String operator;
        int endTrim = 0;
        Matcher m = LAST_CIGAR_OPERATION.matcher(cigar);
        if (m.matches() && "H".equals(operator = m.group(2))) {
            endTrim = Integer.parseInt(m.group(1));
        }
        return endTrim;
    }

    static boolean skipTag(short tag) {
        return tag == SAMTag.MD.getBinaryTag() || tag == SAMTag.OC.getBinaryTag() || tag == SAMTag.OP.getBinaryTag() || tag == SAMTag.OQ.getBinaryTag();
    }

    static SAMBinaryTagAndValue getBinaryAttributes(SAMRecord samRecord) {
        try {
            Field f = samRecord.getClass().getDeclaredField("mAttributes");
            f.setAccessible(true);
            return (SAMBinaryTagAndValue)f.get(samRecord);
        }
        catch (Exception e) {
            return null;
        }
    }

    static String encodeUnsignedArray(String tag, Object value) {
        try {
            Method m = TAG_CODEC.getClass().getDeclaredMethod("encodeUnsignedArray", new Class[0]);
            m.setAccessible(true);
            return (String)m.invoke((Object)TAG_CODEC, new Object[]{tag, value}, new Class[]{String.class, Object.class});
        }
        catch (Exception e) {
            return null;
        }
    }

    static String encodeAttributes(SAMBinaryTagAndValue attribute) {
        StringBuilder sb = new StringBuilder();
        while (attribute != null) {
            if (!SamRecordToAlignment.skipTag(attribute.tag)) {
                String encodedTag = attribute.isUnsignedArray() ? SamRecordToAlignment.encodeUnsignedArray(SAMTag.makeStringTag((short)attribute.tag), attribute.value) : TAG_CODEC.encode(SAMTag.makeStringTag((short)attribute.tag), attribute.value);
                sb.append(encodedTag);
                sb.append("\t");
            }
            attribute = attribute.getNext();
        }
        return sb.toString().trim();
    }
}

