/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.htsjdk;

import htsjdk.samtools.SAMSequenceRecord;
import java.util.ArrayList;
import java.util.Optional;
import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.formats.avro.Reference;
import org.slf4j.Logger;

public final class SamSequenceRecordToReference
extends AbstractConverter<SAMSequenceRecord, Reference> {
    static final String REFSEQ_TAG = "REFSEQ";
    static final String GENBANK_TAG = "GENBANK";

    public SamSequenceRecordToReference() {
        super(SAMSequenceRecord.class, Reference.class);
    }

    public Reference convert(SAMSequenceRecord record, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (record == null) {
            this.warnOrThrow(record, "must not be null", null, stringency, logger);
            return null;
        }
        Reference.Builder builder = Reference.newBuilder();
        if (record.getSequenceIndex() > -1) {
            builder.setIndex(Integer.valueOf(record.getSequenceIndex()));
        }
        if (record.getSequenceLength() > 0) {
            builder.setLength(Long.valueOf(record.getSequenceLength()));
        }
        Optional.ofNullable(record.getSequenceName()).ifPresent(name -> builder.setName(name));
        Optional.ofNullable(record.getMd5()).ifPresent(md5 -> builder.setMd5(md5));
        Optional.ofNullable(record.getSpecies()).ifPresent(species -> builder.setSpecies(species));
        Optional.ofNullable(record.getAttribute("UR")).ifPresent(uri -> builder.setSourceUri(uri));
        ArrayList accessions = new ArrayList(2);
        Optional.ofNullable(record.getAttribute(REFSEQ_TAG)).ifPresent(refseq -> accessions.add(refseq));
        Optional.ofNullable(record.getAttribute(GENBANK_TAG)).ifPresent(genbank -> accessions.add(genbank));
        if (!accessions.isEmpty()) {
            builder.setSourceAccessions(accessions);
        }
        return builder.build();
    }
}

