/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.htsjdk;

import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.variant.vcf.VCFHeader;
import java.util.ArrayList;
import java.util.List;
import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.convert.Converter;
import org.bdgenomics.convert.htsjdk.SamSequenceRecordToReference;
import org.bdgenomics.formats.avro.Reference;
import org.slf4j.Logger;

public final class VcfHeaderToReferences
extends AbstractConverter<VCFHeader, List<Reference>> {
    private final Converter<SAMSequenceRecord, Reference> referenceConverter;

    public VcfHeaderToReferences() {
        this((Converter<SAMSequenceRecord, Reference>)new SamSequenceRecordToReference());
    }

    VcfHeaderToReferences(Converter<SAMSequenceRecord, Reference> referenceConverter) {
        super(VCFHeader.class, List.class);
        this.checkNotNull(referenceConverter);
        this.referenceConverter = referenceConverter;
    }

    public List<Reference> convert(VCFHeader header, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (header == null) {
            this.warnOrThrow(header, "must not be null", null, stringency, logger);
            return null;
        }
        ArrayList<Reference> references = new ArrayList<Reference>();
        if (header.getSequenceDictionary() != null && header.getSequenceDictionary().getSequences() != null) {
            for (SAMSequenceRecord record : header.getSequenceDictionary().getSequences()) {
                references.add((Reference)this.referenceConverter.convert((Object)record, stringency, logger));
            }
        }
        return references;
    }
}

