/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.htsjdk;

import htsjdk.variant.vcf.VCFHeader;
import java.util.ArrayList;
import java.util.List;
import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.formats.avro.Sample;
import org.slf4j.Logger;

public final class VcfHeaderToSamples
extends AbstractConverter<VCFHeader, List<Sample>> {
    public VcfHeaderToSamples() {
        super(VCFHeader.class, List.class);
    }

    public List<Sample> convert(VCFHeader header, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (header == null) {
            this.warnOrThrow(header, "must not be null", null, stringency, logger);
            return null;
        }
        ArrayList<Sample> samples = new ArrayList<Sample>();
        if (header.getGenotypeSamples() != null) {
            Sample.Builder builder = Sample.newBuilder();
            for (String sampleId : header.getGenotypeSamples()) {
                samples.add(builder.setId(sampleId).build());
            }
        }
        return samples;
    }
}

