/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.htsjdk;

import htsjdk.samtools.SAMProgramRecord;
import java.util.Optional;
import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.formats.avro.ProcessingStep;
import org.slf4j.Logger;

public final class SamProgramRecordToProcessingStep
extends AbstractConverter<SAMProgramRecord, ProcessingStep> {
    public SamProgramRecordToProcessingStep() {
        super(SAMProgramRecord.class, ProcessingStep.class);
    }

    public ProcessingStep convert(SAMProgramRecord record, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (record == null) {
            this.warnOrThrow(record, "must not be null", null, stringency, logger);
            return null;
        }
        if (record.getId() == null) {
            this.warnOrThrow(record, "id must not be null", null, stringency, logger);
            return null;
        }
        ProcessingStep.Builder builder = ProcessingStep.newBuilder().setId(record.getId());
        Optional.ofNullable(record.getCommandLine()).ifPresent(commandLine -> builder.setCommandLine(commandLine));
        Optional.ofNullable(record.getPreviousProgramGroupId()).ifPresent(previousId -> builder.setPreviousId(previousId));
        Optional.ofNullable(record.getProgramName()).ifPresent(programName -> builder.setProgramName(programName));
        Optional.ofNullable(record.getProgramVersion()).ifPresent(version -> builder.setVersion(version));
        return builder.build();
    }
}

