/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.htsjdk;

import htsjdk.samtools.ValidationStringency;
import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.slf4j.Logger;

final class ConversionStringencyToValidationStringency
extends AbstractConverter<ConversionStringency, ValidationStringency> {
    ConversionStringencyToValidationStringency() {
        super(ConversionStringency.class, ValidationStringency.class);
    }

    public ValidationStringency convert(ConversionStringency conversionStringency, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (conversionStringency == null) {
            this.warnOrThrow(conversionStringency, "must not be null", null, stringency, logger);
            return null;
        }
        if (conversionStringency.isSilent()) {
            return ValidationStringency.SILENT;
        }
        if (conversionStringency.isLenient()) {
            return ValidationStringency.LENIENT;
        }
        return ValidationStringency.STRICT;
    }
}

