/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.htsjdk;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.formats.avro.Alignment;
import org.slf4j.Logger;

public final class AlignmentToSamRecord
extends AbstractConverter<Alignment, SAMRecord> {
    private static final Pattern ATTRIBUTE = Pattern.compile("([^:]{2,4}):([AifZHB]):(.*)");
    private static final Pattern ARRAY_ATTRIBUTE = Pattern.compile("([cCiIsSf]{1},)(.*)");
    private final SAMFileHeader header;

    @Inject
    public AlignmentToSamRecord(@Assisted SAMFileHeader header) {
        super(Alignment.class, SAMRecord.class);
        this.checkNotNull(header);
        this.header = header;
    }

    public SAMRecord convert(Alignment alignment, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (alignment == null) {
            this.warnOrThrow(alignment, "must not be null", null, stringency, logger);
            return null;
        }
        SAMRecord builder = new SAMRecord(this.header);
        builder.setReadName(alignment.getReadName());
        builder.setReadString(alignment.getSequence());
        if (alignment.getQualityScores() == null) {
            builder.setBaseQualityString("*");
        } else {
            builder.setBaseQualityString(alignment.getQualityScores());
        }
        String readGroupId = alignment.getReadGroupId();
        if (readGroupId != null) {
            builder.setAttribute("RG", (Object)readGroupId);
            SAMReadGroupRecord readGroup = this.header.getReadGroup(readGroupId);
            if (readGroup != null && readGroup.getLibrary() != null) {
                builder.setAttribute("LB", (Object)readGroup.getLibrary());
            }
            if (readGroup != null && readGroup.getPlatformUnit() != null) {
                builder.setAttribute("PU", (Object)readGroup.getPlatformUnit());
            }
        }
        if (alignment.getMateReferenceName() != null) {
            builder.setMateReferenceName(alignment.getMateReferenceName());
        }
        if (alignment.getMateAlignmentStart() != null) {
            builder.setMateAlignmentStart(alignment.getMateAlignmentStart().intValue() + 1);
        }
        if (alignment.getInsertSize() != null) {
            builder.setInferredInsertSize(alignment.getInsertSize().intValue());
        }
        if (alignment.getReadPaired() != null) {
            boolean readPaired = alignment.getReadPaired();
            builder.setReadPairedFlag(readPaired);
            if (readPaired) {
                if (alignment.getMateNegativeStrand() != null) {
                    builder.setMateNegativeStrandFlag(alignment.getMateNegativeStrand().booleanValue());
                }
                if (alignment.getMateMapped() != null) {
                    builder.setMateUnmappedFlag(alignment.getMateMapped() == false);
                }
                if (alignment.getProperPair() != null) {
                    builder.setProperPairFlag(alignment.getProperPair().booleanValue());
                }
                if (alignment.getReadInFragment() != null) {
                    builder.setFirstOfPairFlag(alignment.getReadInFragment() == 0);
                    builder.setSecondOfPairFlag(alignment.getReadInFragment() == 1);
                }
            }
        }
        if (alignment.getDuplicateRead() != null) {
            builder.setDuplicateReadFlag(alignment.getDuplicateRead().booleanValue());
        }
        if (alignment.getReadMapped() != null) {
            boolean readMapped = alignment.getReadMapped();
            builder.setReadUnmappedFlag(!readMapped);
            if (alignment.getReadNegativeStrand() != null) {
                builder.setReadNegativeStrandFlag(alignment.getReadNegativeStrand().booleanValue());
            }
            if (readMapped) {
                if (alignment.getReferenceName() == null) {
                    this.warnOrThrow(alignment, "referenceName must not be null if read aligned", null, stringency, logger);
                } else {
                    builder.setReferenceName(alignment.getReferenceName());
                }
                if (alignment.getCigar() != null) {
                    builder.setCigarString(alignment.getCigar());
                }
                if (alignment.getPrimaryAlignment() != null) {
                    builder.setNotPrimaryAlignmentFlag(alignment.getPrimaryAlignment() == false);
                }
                if (alignment.getSupplementaryAlignment() != null) {
                    builder.setSupplementaryAlignmentFlag(alignment.getSupplementaryAlignment().booleanValue());
                }
                if (alignment.getStart() != null) {
                    builder.setAlignmentStart(alignment.getStart().intValue() + 1);
                }
                if (alignment.getMappingQuality() != null) {
                    builder.setMappingQuality(alignment.getMappingQuality().intValue());
                }
            } else {
                builder.setMappingQuality(0);
            }
        }
        if (alignment.getFailedVendorQualityChecks() != null) {
            builder.setReadFailsVendorQualityCheckFlag(alignment.getFailedVendorQualityChecks().booleanValue());
        }
        if (alignment.getMismatchingPositions() != null) {
            builder.setAttribute("MD", (Object)alignment.getMismatchingPositions());
        }
        if (alignment.getOriginalQualityScores() != null) {
            builder.setOriginalBaseQualities(SAMUtils.fastqToPhred((String)alignment.getOriginalQualityScores()));
        }
        if (alignment.getOriginalCigar() != null) {
            builder.setAttribute("OC", (Object)alignment.getOriginalCigar());
        }
        if (alignment.getOriginalStart() != null) {
            builder.setAttribute("OP", (Object)(alignment.getOriginalStart().intValue() + 1));
        }
        if (alignment.getAttributes() != null) {
            String[] tokens;
            for (String token : tokens = alignment.getAttributes().split("\t")) {
                Matcher m = ATTRIBUTE.matcher(token);
                if (!m.matches()) continue;
                String tagName = m.group(1);
                String tagType = m.group(2);
                String value = m.group(3);
                if ("B".equals(tagType) && (m = ARRAY_ATTRIBUTE.matcher(value)).matches()) {
                    tagType = tagType + ":" + m.group(1);
                    value = m.group(2);
                }
                switch (tagType) {
                    case "A": {
                        builder.setAttribute(tagName, (Object)Character.valueOf(value.charAt(0)));
                    }
                    case "i": {
                        builder.setAttribute(tagName, (Object)Integer.valueOf(value));
                    }
                    case "f": {
                        builder.setAttribute(tagName, (Object)Float.valueOf(value));
                    }
                    case "Z": {
                        builder.setAttribute(tagName, (Object)value);
                    }
                    case "H": {
                        builder.setAttribute(tagName, (Object)value.getBytes());
                    }
                    case "B:c,": 
                    case "B:C,": {
                        builder.setAttribute(tagName, (Object)AlignmentToSamRecord.splitToByteArray(value));
                    }
                    case "B:i,": 
                    case "B:I,": {
                        builder.setAttribute(tagName, (Object)AlignmentToSamRecord.splitToIntegerArray(value));
                    }
                    case "B:s,": 
                    case "B:S,": {
                        builder.setAttribute(tagName, (Object)AlignmentToSamRecord.splitToShortArray(value));
                    }
                    case "B:f,": {
                        builder.setAttribute(tagName, (Object)AlignmentToSamRecord.splitToFloatArray(value));
                    }
                }
                this.warnOrThrow(alignment, "invalid attribute type " + tagType, null, stringency, logger);
            }
        }
        return builder;
    }

    static byte[] splitToByteArray(String value) {
        String[] tokens = value.split(",");
        byte[] bytes = new byte[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            bytes[i] = Byte.valueOf(tokens[i]);
        }
        return bytes;
    }

    static int[] splitToIntegerArray(String value) {
        String[] tokens = value.split(",");
        int[] ints = new int[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            ints[i] = Integer.valueOf(tokens[i]);
        }
        return ints;
    }

    static short[] splitToShortArray(String value) {
        String[] tokens = value.split(",");
        short[] shorts = new short[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            shorts[i] = Short.valueOf(tokens[i]);
        }
        return shorts;
    }

    static float[] splitToFloatArray(String value) {
        String[] tokens = value.split(",");
        float[] floats = new float[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            floats[i] = Float.valueOf(tokens[i]).floatValue();
        }
        return floats;
    }
}

