/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.htsjdk;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFHeader;
import java.util.List;
import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.formats.avro.Genotype;
import org.slf4j.Logger;

public final class GenotypesToVariantContext
extends AbstractConverter<List<Genotype>, VariantContext> {
    private final VCFHeader header;

    @Inject
    public GenotypesToVariantContext(@Assisted VCFHeader header) {
        super(List.class, VariantContext.class);
        this.checkNotNull(header);
        this.header = header;
    }

    public VariantContext convert(List<Genotype> genotypes, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (genotypes == null) {
            this.warnOrThrow(genotypes, "must not be null", null, stringency, logger);
            return null;
        }
        if (genotypes.isEmpty()) {
            this.warnOrThrow(genotypes, "must not be empty", null, stringency, logger);
            return null;
        }
        return null;
    }
}

