/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.htsjdk;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import java.util.ArrayList;
import java.util.List;
import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.convert.Converter;
import org.bdgenomics.convert.htsjdk.SamReadGroupRecordToReadGroup;
import org.bdgenomics.formats.avro.ReadGroup;
import org.slf4j.Logger;

public final class SamHeaderToReadGroups
extends AbstractConverter<SAMFileHeader, List<ReadGroup>> {
    private final Converter<SAMReadGroupRecord, ReadGroup> readGroupConverter;

    public SamHeaderToReadGroups() {
        this((Converter<SAMReadGroupRecord, ReadGroup>)new SamReadGroupRecordToReadGroup());
    }

    public SamHeaderToReadGroups(Converter<SAMReadGroupRecord, ReadGroup> readGroupConverter) {
        super(SAMFileHeader.class, List.class);
        this.checkNotNull(readGroupConverter);
        this.readGroupConverter = readGroupConverter;
    }

    public List<ReadGroup> convert(SAMFileHeader header, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (header == null) {
            this.warnOrThrow(header, "must not be null", null, stringency, logger);
            return null;
        }
        ArrayList<ReadGroup> readGroups = new ArrayList<ReadGroup>();
        if (header.getReadGroups() != null) {
            for (SAMReadGroupRecord record : header.getReadGroups()) {
                readGroups.add((ReadGroup)this.readGroupConverter.convert((Object)record, stringency, logger));
            }
        }
        return readGroups;
    }
}

