/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.bdosclient;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.audit.client.AuditDoipClient;
import org.bdware.doip.audit.writer.AuditConfig;
import org.bdware.doip.audit.writer.NoneAuditConfig;
import org.bdware.doip.codec.digitalObject.DigitalObject;
import org.bdware.doip.codec.digitalObject.DoType;
import org.bdware.doip.codec.doipMessage.DoipMessage;
import org.bdware.doip.codec.doipMessage.DoipMessageFactory;
import org.bdware.doip.codec.doipMessage.DoipMessageSigner;
import org.bdware.doip.codec.doipMessage.DoipResponseCode;
import org.bdware.doip.codec.operations.BasicOperations;
import org.bdware.doip.encrypt.SM2Signer;
import org.bdware.doip.endpoint.client.ClientConfig;
import org.bdware.doip.endpoint.client.DoipMessageCallback;
import org.bdware.irp.client.IrpClient;
import org.bdware.irp.stateinfo.StateInfoBase;
import org.zz.gmhelper.SM2KeyPair;

public class CodeRepoClient {
    private final SM2KeyPair keyPair;
    private final String repoDoid;
    private final IrpClient irpClient;
    AuditDoipClient client;
    static Logger LOGGER = LogManager.getLogger(CodeRepoClient.class);
    static ExecutorService threadPool = Executors.newFixedThreadPool(5);

    public static String getDefaultCodeRepo(String prefix) {
        return prefix.replaceAll("/.*$", "") + "/CodeRepository";
    }

    public CodeRepoClient(String repoDoid, IrpClient irpClient, SM2KeyPair keyPair) {
        this.keyPair = keyPair;
        this.repoDoid = repoDoid;
        this.irpClient = irpClient;
    }

    private void initClient() {
        try {
            if (this.client != null) {
                return;
            }
            StateInfoBase resolveResult = this.irpClient.resolve(this.repoDoid);
            NoneAuditConfig config = new NoneAuditConfig(null);
            this.client = new AuditDoipClient((AuditConfig)config, (DoipMessageSigner)new SM2Signer(this.keyPair));
            this.client.connect(ClientConfig.fromUrl((String)resolveResult.handleValues.get("address").getAsString()));
            this.client.setTimeout(30000L);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.client = null;
        }
    }

    public void createAndUpload(final String path, final ProgressCallback progressCallback) {
        this.initClient();
        this.createYPK(path, new DoipMessageCallback(){

            public void onResult(final DoipMessage msg) {
                progressCallback.onStart(msg.header.parameters.id);
                if (msg.header.parameters.response != DoipResponseCode.Success) {
                    progressCallback.onError("error in create doid", msg);
                    return;
                }
                threadPool.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            int chunk = 1000;
                            if (msg.header.parameters.attributes.has("chunkSize")) {
                                chunk = msg.header.parameters.attributes.get("chunkSize").getAsInt();
                            }
                            CodeRepoClient.this.uploadChuckByChunk(msg.header.parameters.id, path, chunk, progressCallback);
                        }
                        catch (Exception e) {
                            ByteArrayOutputStream bo = new ByteArrayOutputStream();
                            e.printStackTrace(new PrintStream(bo));
                            progressCallback.onError("error in upload:" + new String(bo.toByteArray()), null);
                            e.printStackTrace();
                        }
                    }
                });
            }
        });
    }

    private void uploadChuckByChunk(String doid, String path, long chunkSize, ProgressCallback progressCallback) throws Exception {
        double step;
        long total = new File(path).length();
        double progress = step = (double)0.05f;
        RandomAccessFile accessFile = new RandomAccessFile(new File(path), "r");
        byte[] buff = new byte[(int)chunkSize];
        int i = 0;
        while ((long)i < total) {
            long len = accessFile.read(buff);
            DoipMessageFactory.DoipMessageBuilder builder = new DoipMessageFactory.DoipMessageBuilder().createRequest(doid, BasicOperations.Update.getName());
            if (len == chunkSize) {
                builder.setBody(buff);
            } else {
                byte[] readed = new byte[(int)len];
                System.arraycopy(buff, 0, readed, 0, (int)len);
                builder.setBody(readed);
            }
            LOGGER.info("upload:" + i + " total:" + total + " size:" + chunkSize);
            builder.addAttributes("currentPos", i);
            if ((long)i + chunkSize >= total) {
                builder.addAttributes("lastChunk", "true");
            }
            DoipMessage resp = this.client.sendMessageSync(builder.create());
            if (resp.header.parameters.response != DoipResponseCode.Success) {
                progressCallback.onError("unknowns error in uploading", resp);
                return;
            }
            if ((double)((long)i / total) >= progress) {
                progress += step;
                progressCallback.onProgress(doid, i, (int)total);
            }
            i = (int)((long)i + chunkSize);
        }
        progressCallback.onFinish(doid);
    }

    private void createYPK(String path, DoipMessageCallback cb) {
        DigitalObject digitalObject = new DigitalObject(null, DoType.DO);
        digitalObject.id = "/";
        digitalObject.attributes = new JsonObject();
        digitalObject.attributes.addProperty("owner", this.keyPair.getPublicKeyStr());
        String fileName = new File(path).getName();
        int offset = fileName.lastIndexOf("-");
        String ypkName = fileName.substring(0, offset);
        int suffixOffset = fileName.lastIndexOf(".ypk");
        String version = fileName.substring(offset + 1, suffixOffset);
        digitalObject.attributes.addProperty("ypkName", ypkName);
        digitalObject.attributes.addProperty("version", version);
        digitalObject.attributes.addProperty("md5", this.calFileMd5(path));
        digitalObject.attributes.addProperty("fileSize", (Number)new File(path).length());
        this.client.create(this.repoDoid, digitalObject, cb);
    }

    public void deleteYPK(String doid, DoipMessageCallback cb) {
        this.initClient();
        this.client.delete(doid, cb);
    }

    public void retrieveBCO(String doid, DoipMessageCallback cb) {
        this.initClient();
        this.client.retrieve(doid, "-1", false, cb);
    }

    public void listPackages(int offset, int count, DoipMessageCallback cb) {
        this.initClient();
        DoipMessage msg = new DoipMessageFactory.DoipMessageBuilder().createRequest(this.repoDoid, BasicOperations.Retrieve.getName()).create();
        msg.header.parameters.addAttribute("element", "0");
        msg.header.parameters.addAttribute("includeElementData", "true");
        msg.header.parameters.addAttribute("offset", offset);
        msg.header.parameters.addAttribute("count", count);
        this.client.sendMessage(msg, cb);
    }

    public void downloadYPK(final String doid, final ProgressCallback progressCallback, final File output) {
        this.initClient();
        DoipMessage message = this.client.retrieveSync(doid, "", false);
        if (message.header.parameters.response == DoipResponseCode.Success) {
            final JsonObject resolved = JsonParser.parseString((String)message.body.getDataAsJsonString()).getAsJsonObject();
            resolved.addProperty("chunkSize", message.header.parameters.attributes.get("chunkSize").getAsString());
            progressCallback.onStart(doid);
            threadPool.execute(new Runnable(){

                @Override
                public void run() {
                    CodeRepoClient.this.downloadInternal(doid, resolved, progressCallback, output);
                }
            });
        }
    }

    private void downloadInternal(String doid, JsonObject resolved, ProgressCallback progressCallback, File output) {
        int total = resolved.get("fileSize").getAsInt();
        int chunkSize = resolved.get("chunkSize").getAsInt();
        try {
            File parent = output.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            if (output.exists()) {
                output.delete();
            }
            output.createNewFile();
            FileOutputStream fout = new FileOutputStream(output);
            double step = 0.05;
            double progress = 0.0;
            int i = 0;
            while (i * chunkSize < total) {
                DoipMessage doipMessage = this.client.retrieveSync(doid, i + "", true);
                fout.write(doipMessage.body.getEncodedData());
                if (((double)(i * chunkSize) + 0.0) / ((double)total + 0.0) > progress) {
                    progressCallback.onProgress(doid, i * chunkSize, total);
                    progress += step;
                }
                ++i;
            }
            fout.close();
            String md5 = this.calFileMd5(output.getAbsolutePath());
            if (!md5.equals(resolved.get("md5").getAsString())) {
                progressCallback.onError("verify failed! redownload and check", null);
            }
            progressCallback.onFinish(doid);
        }
        catch (Exception e) {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bo));
            progressCallback.onError(new String(bo.toByteArray()), null);
        }
    }

    public String calFileMd5(String path) {
        String md5 = "errormd5";
        try {
            md5 = DigestUtils.md5Hex((InputStream)new FileInputStream(path));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return md5;
    }

    public static interface ProgressCallback {
        public void onStart(String var1);

        public void onProgress(String var1, int var2, int var3);

        public void onFinish(String var1);

        public void onError(String var1, DoipMessage var2);
    }
}

