/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.bdosclient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.bdware.doip.audit.client.AuditDoipClient;
import org.bdware.doip.audit.writer.AuditConfig;
import org.bdware.doip.audit.writer.NoneAuditConfig;
import org.bdware.doip.codec.digitalObject.DigitalObject;
import org.bdware.doip.codec.digitalObject.DoType;
import org.bdware.doip.codec.doipMessage.DoipMessage;
import org.bdware.doip.codec.doipMessage.DoipMessageSigner;
import org.bdware.doip.codec.exception.DoipConnectException;
import org.bdware.doip.encrypt.SM2Signer;
import org.bdware.doip.endpoint.client.ClientConfig;
import org.bdware.doip.endpoint.client.DoipMessageCallback;
import org.bdware.irp.client.IrpClient;
import org.bdware.irp.stateinfo.StateInfoBase;
import org.zz.gmhelper.SM2KeyPair;

public class BDRepoClient {
    private final SM2KeyPair keyPair;
    private final IrpClient irpClient;
    private final String repoDoid;
    AuditDoipClient client;

    public BDRepoClient(String repoDoid, IrpClient irpClient, SM2KeyPair keyPair) {
        this.keyPair = keyPair;
        this.irpClient = irpClient;
        this.repoDoid = repoDoid;
        try {
            StateInfoBase resolveResult = irpClient.resolve(repoDoid);
            NoneAuditConfig config = new NoneAuditConfig(null);
            this.client = new AuditDoipClient((AuditConfig)config, (DoipMessageSigner)new SM2Signer(keyPair));
            this.client.connect(ClientConfig.fromUrl((String)resolveResult.handleValues.get("address").getAsString()));
            this.client.setTimeout(30000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createBDO(String bCoId, int shardingId, JsonElement createParam, int doipStartPort, SM2KeyPair keyPair, final StartBDOResultCallback cb) {
        final StartBDOResult result = new StartBDOResult();
        result.executionTime = System.currentTimeMillis();
        if (doipStartPort > 0) {
            createParam.getAsJsonObject().addProperty("doipStartPort", (Number)doipStartPort);
        }
        DoipMessageCallback converter = new DoipMessageCallback(){

            public void onResult(DoipMessage msg) {
                try {
                    JsonObject dataObj = JsonParser.parseString((String)msg.body.getDataAsJsonString()).getAsJsonObject();
                    result.originalMessage = msg;
                    result.doipListenerPort = dataObj.get("doipListenPort").getAsInt();
                    result.doipOnStart = dataObj.get("doipModuleStartResult");
                    result.onCreate = dataObj.get("onCreate").getAsJsonObject();
                    result.publicKey = dataObj.get("loadContract").getAsJsonObject().get("result").getAsString();
                    result.isValid = true;
                    result.shortId = result.publicKey.hashCode();
                }
                catch (Exception e) {
                    result.isValid = false;
                    result.originalMessage = msg;
                }
                result.executionTime = System.currentTimeMillis() - result.executionTime;
                cb.onResult(result);
            }
        };
        JsonObject jo = new JsonObject();
        jo.add("createParam", createParam);
        jo.addProperty("bCoId", bCoId);
        jo.addProperty("shardingId", (Number)shardingId);
        if (keyPair != null) {
            jo.add("sm2KeyPair", JsonParser.parseString((String)keyPair.toJson()));
        }
        DigitalObject digitalObject = new DigitalObject("unknown", DoType.DO);
        digitalObject.attributes = jo;
        this.ensureConnected();
        this.client.create(this.repoDoid, digitalObject, converter);
    }

    public void deleteBDO(String idOrName, DoipMessageCallback cb) {
        JsonObject jo = new JsonObject();
        this.ensureConnected();
        this.client.delete(idOrName, cb);
    }

    public void ensureConnected() {
        if (!this.client.isConnected()) {
            try {
                this.client.reconnect();
            }
            catch (DoipConnectException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static interface StartBDOResultCallback {
        public void onResult(StartBDOResult var1);
    }

    public static class StartBDOResult {
        int shortId;
        String publicKey;
        JsonElement onCreate;
        JsonElement doipOnStart;
        int doipListenerPort;
        boolean isValid;
        transient DoipMessage originalMessage;
        long executionTime;
    }
}

