package org.bdware.bdosclient;

import com.google.gson.JsonObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.client.SmartContractClient;
import org.bdware.client.ws.Action;
import org.zz.gmhelper.SM2KeyPair;

import java.util.concurrent.atomic.AtomicInteger;

public class ExtClient extends SmartContractClient {
    static Logger LOGGER = LogManager.getLogger(ExtClient.class);
    public AtomicInteger i = new AtomicInteger(0);
    private boolean loggedIn = false;

    public ExtClient(String uri, SM2KeyPair pair) {
        super(uri, pair);
    }

    @Override
    public void onLogin(JsonObject obj) {
        loggedIn = true;
    }

    @Action
    public void onListContractProcess(JsonObject obj) {
        LOGGER.info(obj);
        i.getAndIncrement();
        synchronized (this) {
            this.notify();
        }
    }

    public void waitForLogin() {
        for (; !loggedIn; )
            Thread.yield();
    }
}
