package org.bdware.bdosclient;

import com.google.gson.JsonSyntaxException;
import org.bdware.doip.audit.AuditDoaClient;
import org.bdware.doip.codec.doipMessage.DoipMessage;
import org.bdware.doip.codec.doipMessage.DoipMessageFactory;
import org.bdware.doip.codec.operations.BasicOperations;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;

public class GlobalVarClient {
    // TODO @wangxuxing
    public <T> T readFromRepo(String bdrepoID, String globalVar, Class<T> classOfT) throws JsonSyntaxException {
        AuditDoaClient client = null;
        DoipMessageFactory.DoipMessageBuilder builder = new DoipMessageFactory.DoipMessageBuilder();
        builder.createRequest(bdrepoID, BasicOperations.Retrieve.getName());
        DoipMessage msg = builder.create();
        msg.header.parameters.addAttribute("readGlobalVar", globalVar);
        DoipMessage doipMessage = client.sendRawMessageSync(msg, 5000L);
        try {
            byte[] data = doipMessage.body.getEncodedData();
            ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(data));
            return (T) oin.readObject();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}
