/*
 *    Copyright (c) [2021] [Peking University]
 *    [BDWare doip sdk] is licensed under Mulan PSL v2.
 *    You can use this software according to the terms and conditions of the Mulan PSL v2.
 *    You may obtain a copy of Mulan PSL v2 at:
 *             http://license.coscl.org.cn/MulanPSL2
 *    THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 *    See the Mulan PSL v2 for more details.
 */

package org.bdware.doip.codec.doipMessage;

import java.net.InetSocketAddress;

public class DoipMessage {

    public transient int requestID = 0;

    private transient String recipientID = null;        //mainly user to encryption

    public MessageHeader header;
    public MessageBody body;
    public MessageCredential credential;

    public DoipMessage(String id, String opCode) {
        header = new MessageHeader(id, opCode);
        body = new MessageBody();
    }

    public DoipMessage(String id, String opCode, int flag) {
        header = new MessageHeader(id, opCode, flag);
        body = new MessageBody();
    }

    public boolean isRequest() {
        return header.isRequest();
    }

    public String getRecipientID() {
        return recipientID;
    }

    public void setRecipientID(String recipientID) {
        this.recipientID = recipientID;
    }

    transient InetSocketAddress sender = null;

    public InetSocketAddress getSender() {
        return sender;
    }

    public void setSender(InetSocketAddress sender) {
        this.sender = sender;
    }
}
