/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.codec.doipMessage;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.bdware.doip.codec.utils.DoipGson;

public class MessageCredential {
    public JsonObject attributes;
    int sigLength = 0;
    byte[] signature;

    public MessageCredential(String signer, byte[] sig) {
        this.attributes = new JsonObject();
        this.setSignature(sig);
        this.setSigner(signer);
    }

    public MessageCredential(String signer) {
        this.attributes = new JsonObject();
        this.setSigner(signer);
    }

    public MessageCredential(JsonObject attributes) {
        this.attributes = attributes;
    }

    public int attributeLength() {
        return DoipGson.getDoipGson().toJson((JsonElement)this.attributes).getBytes().length;
    }

    public int sigLength() {
        return this.sigLength;
    }

    public int getTotalLength() {
        return this.attributeLength() + this.sigLength + 4 + 4;
    }

    public String getSigner() {
        if (this.attributes.has("signer")) {
            return this.attributes.get("signer").getAsString();
        }
        return null;
    }

    public void setSigner(String signer) {
        this.attributes.addProperty("signer", signer);
    }

    public void setAttributes(String key, String value) {
        this.attributes.addProperty(key, value);
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void setSignature(byte[] sig) {
        this.sigLength = sig.length;
        this.signature = sig;
    }
}

