/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.server;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.net.URI;
import java.util.List;
import org.bdware.doip.codec.digitalObject.DigitalObject;
import org.bdware.doip.codec.digitalObject.DoType;
import org.bdware.doip.endpoint.server.DoipListenerConfig;

public class DoipServiceInfo {
    public String id;
    public String serviceDescription;
    public String publicKey;
    public String serviceName;
    public int port;
    public String ipAddress;
    public String protocol;
    public String protocolVersion;
    public List<DoipListenerConfig> listenerInfos;
    public String owner;
    public String repoType;

    public DoipServiceInfo(String id, String owner, String repoType, List<DoipListenerConfig> listenerInfos) {
        this.id = id;
        this.owner = owner;
        this.repoType = repoType;
        this.listenerInfos = listenerInfos;
        String url = listenerInfos.get((int)0).url;
        URI uri = URI.create(url);
        this.protocol = uri.getScheme();
        this.ipAddress = uri.getHost();
        this.port = uri.getPort();
        this.protocolVersion = listenerInfos.get((int)0).protocolVersion;
    }

    public static DoipServiceInfo fromJson(String str) {
        return (DoipServiceInfo)new Gson().fromJson(str, DoipServiceInfo.class);
    }

    public String toJson() {
        return new Gson().toJson((Object)this);
    }

    public byte[] toBytes() {
        return this.toJson().getBytes();
    }

    public DigitalObject toDigitalObject() {
        DigitalObject dObj = new DigitalObject(this.id, DoType.DOIPServiceInfo);
        dObj.addAttribute("serviceName", this.serviceName);
        dObj.addAttribute("serviceDescription", this.serviceDescription);
        dObj.addAttribute("owner", this.owner);
        dObj.addAttribute("repoType", this.repoType);
        dObj.addAttribute("publicKey", this.publicKey);
        dObj.addAttribute("protocol", this.protocol);
        dObj.addAttribute("protocolVersion", this.protocolVersion);
        dObj.addAttribute("port", this.port);
        dObj.addAttribute("ipAddress", this.ipAddress);
        dObj.addAttribute("listenerInfos", new Gson().toJson(this.listenerInfos));
        return dObj;
    }

    public static DoipServiceInfo fromDigitalObject(DigitalObject dObj) {
        List ss = (List)new Gson().fromJson(dObj.attributes.get("listenerInfos").getAsString(), new TypeToken<List<DoipListenerConfig>>(){}.getType());
        DoipServiceInfo serviceInfo = new DoipServiceInfo(dObj.id, dObj.attributes.get("owner").getAsString(), dObj.attributes.get("repoType").getAsString(), ss);
        serviceInfo.serviceName = dObj.attributes.get("serviceName") == null ? "" : dObj.attributes.get("serviceName").getAsString();
        serviceInfo.publicKey = dObj.attributes.get("publicKey") == null ? "" : dObj.attributes.get("publicKey").getAsString();
        serviceInfo.serviceDescription = dObj.attributes.get("serviceDescription") == null ? "" : dObj.attributes.get("serviceDescription").getAsString();
        serviceInfo.repoType = dObj.attributes.get("repoType") == null ? "" : dObj.attributes.get("repoType").getAsString();
        return serviceInfo;
    }
}

