/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.server;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import org.apache.log4j.Logger;
import org.bdware.doip.codec.digitalObject.DigitalObject;
import org.bdware.doip.codec.doipMessage.DoipMessage;
import org.bdware.doip.codec.doipMessage.DoipMessageFactory;
import org.bdware.doip.codec.doipMessage.DoipResponseCode;
import org.bdware.doip.codec.operations.BasicOperations;
import org.bdware.doip.codec.utils.DoipGson;
import org.bdware.doip.endpoint.server.DoipServiceInfo;
import org.bdware.doip.endpoint.server.Op;
import org.bdware.doip.endpoint.server.RepositoryHandler;

public abstract class RepositoryHandlerBase
implements RepositoryHandler {
    Logger logger = Logger.getLogger(RepositoryHandlerBase.class);
    protected DoipServiceInfo serviceInfo;

    public RepositoryHandlerBase(DoipServiceInfo info) {
        this.serviceInfo = info;
    }

    @Override
    public abstract DoipMessage handleHello(DoipMessage var1);

    @Override
    public abstract DoipMessage handleListOps(DoipMessage var1);

    @Override
    public abstract DoipMessage handleCreate(DoipMessage var1);

    @Override
    public abstract DoipMessage handleUpdate(DoipMessage var1);

    @Override
    public abstract DoipMessage handleDelete(DoipMessage var1);

    @Override
    public abstract DoipMessage handleRetrieve(DoipMessage var1);

    @Op(op=BasicOperations.Unknown)
    public DoipMessage handleUnknown(DoipMessage request) {
        return this.replyStringWithStatus(request, "Unsupported Operation!", DoipResponseCode.Declined);
    }

    protected DoipMessage replyAllOperations(DoipMessage request) {
        JsonArray allBasicOps = new JsonArray();
        for (BasicOperations op : BasicOperations.values()) {
            allBasicOps.add(op.getName());
        }
        return this.replyString(request, DoipGson.getDoipGson().toJson((JsonElement)allBasicOps));
    }

    protected DoipMessage replyDoipServiceInfo(DoipMessage request) {
        DigitalObject respDO = this.serviceInfo.toDigitalObject();
        respDO.needSign();
        return this.replyDO(request, respDO);
    }

    protected DoipMessage replyDO(DoipMessage request, DigitalObject digitalObject) {
        DoipMessage response = new DoipMessageFactory.DoipMessageBuilder().createResponse(DoipResponseCode.Success, request).setBody(digitalObject).create();
        this.logger.debug((Object)("[response message]" + DoipGson.getDoipGson().toJson((JsonElement)digitalObject.attributes)));
        return response;
    }

    protected DoipMessage replyNull(DoipMessage inMsg) {
        DoipMessage response = new DoipMessageFactory.DoipMessageBuilder().createResponse(DoipResponseCode.Success, inMsg).create();
        return response;
    }

    protected DoipMessage replyString(DoipMessage inMsg, String retStr) {
        return this.replyStringWithStatus(inMsg, retStr, DoipResponseCode.Success);
    }

    protected DoipMessage replyBytes(DoipMessage inMsg, byte[] b) {
        DoipMessage response = new DoipMessageFactory.DoipMessageBuilder().createResponse(DoipResponseCode.Success, inMsg).setBody(b).create();
        return response;
    }

    protected DoipMessage replyStringWithStatus(DoipMessage request, String str, DoipResponseCode resp) {
        DoipMessage response = new DoipMessageFactory.DoipMessageBuilder().createResponse(resp, request).setBody(str.getBytes()).create();
        return response;
    }
}

