/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.client;

import java.net.URI;
import java.net.URISyntaxException;
import org.bdware.doip.endpoint.client.TLSClientConfig;

public class ClientConfig {
    public String url;
    public String protocolVersion;

    public ClientConfig(String url) {
        this(url, "2.1");
    }

    public ClientConfig(String url, String protocolVersion) {
        this.url = url;
        this.protocolVersion = protocolVersion;
    }

    public static ClientConfig fromUrl(String url) {
        return ClientConfig.fromUrl(url, "2.1");
    }

    public static ClientConfig fromUrl(String url, String protocolVersion) {
        URI uri = null;
        try {
            uri = new URI(url);
            if (uri.getScheme().toLowerCase().equals("tls")) {
                ClientConfig ret = TLSClientConfig.getDefault(url);
                ret.protocolVersion = protocolVersion;
                return ret;
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return new ClientConfig(url, protocolVersion);
    }
}

