/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.client;

import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import org.apache.log4j.Logger;
import org.bdware.doip.codec.doipMessage.DoipMessage;
import org.bdware.doip.endpoint.client.DoipClientChannel;
import org.bdware.doip.endpoint.client.DoipMessageCallback;
import org.bdware.doip.endpoint.client.NettyDoipClientHandler;

public abstract class NettyDoipClientChannel
implements DoipClientChannel {
    static Logger logger = Logger.getLogger(NettyDoipClientChannel.class);
    protected NettyDoipClientHandler handler;
    InetSocketAddress remoteAddress;
    protected boolean isConnected = false;
    protected Channel channel;

    @Override
    public void sendMessage(DoipMessage message, DoipMessageCallback cb) {
        if (this.handler == null) {
            logger.error((Object)"client handler not set yet");
            return;
        }
        if (!this.isConnected) {
            logger.error((Object)"client not connected, connect first!");
        }
        logger.debug((Object)"channel send message");
        this.handler.sendMessage(message, cb);
    }

    @Override
    public abstract void connect(String var1) throws URISyntaxException;

    @Override
    public boolean isConnected() {
        return this.channel != null && this.channel.isActive();
    }
}

