/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.client;

import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.bdware.doip.endpoint.client.ClientConfig;

public class TLSClientConfig
extends ClientConfig {
    public final TrustManager[] managers;
    static Logger LOGGER = LogManager.getLogger(TLSClientConfig.class);

    public TLSClientConfig(String url, TrustManager[] managers) {
        super(url);
        this.managers = managers;
    }

    public static ClientConfig getDefault(String url) {
        X509TrustManager DUMMY_TRUST_MANAGER = new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
                LOGGER.debug((Object)("[TLSClientConfig] UNKNOWN CLIENT CERTIFICATE: " + chain[0].getSubjectDN()));
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
                LOGGER.debug((Object)("UNKNOWN SERVER CERTIFICATE: " + chain[0].getSubjectDN()));
            }
        };
        TLSClientConfig ret = new TLSClientConfig(url, new TrustManager[]{DUMMY_TRUST_MANAGER});
        return ret;
    }
}

