/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageCodec;
import java.net.InetSocketAddress;
import java.util.List;
import org.apache.log4j.Logger;
import org.bdware.doip.codec.MessageEnvelopeCodec;
import org.bdware.doip.codec.doipMessage.MessageEnvelope;

public class DatagramPacketToMessageEnvelopeCodec
extends MessageToMessageCodec<DatagramPacket, MessageEnvelope> {
    static Logger LOGGER = Logger.getLogger(DatagramPacketToMessageEnvelopeCodec.class);
    InetSocketAddress address = null;

    public DatagramPacketToMessageEnvelopeCodec() {
    }

    public DatagramPacketToMessageEnvelopeCodec(String host, int port) {
        this.address = new InetSocketAddress(host, port);
    }

    protected void encode(ChannelHandlerContext ctx, MessageEnvelope msg, List<Object> out) throws Exception {
        try {
            ByteBuf buf = ctx.alloc().directBuffer();
            MessageEnvelopeCodec.envelopeToBytes(msg, buf);
            DatagramPacket packet = new DatagramPacket(buf, msg.getSender());
            out.add(packet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void decode(ChannelHandlerContext ctx, DatagramPacket msg, List<Object> out) throws Exception {
        ByteBuf buf = (ByteBuf)msg.content();
        MessageEnvelope messageEnvelope = new MessageEnvelope((InetSocketAddress)msg.sender());
        MessageEnvelopeCodec.byteBufToEnvelope(buf, messageEnvelope);
        out.add(messageEnvelope);
    }
}

