/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.server;

import com.google.gson.Gson;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.bdware.doip.codec.doipMessage.DoipMessage;
import org.bdware.doip.codec.doipMessage.DoipMessageFactory;
import org.bdware.doip.codec.doipMessage.DoipResponseCode;
import org.bdware.doip.endpoint.server.DoipRequestHandler;

@ChannelHandler.Sharable
public class NettyServerHandler
extends SimpleChannelInboundHandler<DoipMessage> {
    static Logger logger = Logger.getLogger(NettyServerHandler.class);
    protected DoipRequestHandler requestHandler;
    HashMap<Integer, PushFileStream> clientMap = new HashMap();
    private int streamPushInterval = 500;

    public NettyServerHandler(DoipRequestHandler doipHandler) {
        this.requestHandler = doipHandler;
    }

    protected void channelRead0(ChannelHandlerContext ctx, DoipMessage msg) {
        logger.debug((Object)("receive a message: " + new Gson().toJson((Object)msg.header)));
        if (msg.header.parameters == null || msg.header.parameters.operation == null) {
            this.replyStringWithStatus(ctx, msg, "invalid request", DoipResponseCode.Invalid);
            return;
        }
        if (msg.header.parameters.attributes != null && msg.header.parameters.attributes.get("action") != null) {
            if (msg.header.parameters.attributes.get("action").getAsString().equals("start")) {
                logger.info((Object)"send DO stream");
                this.sendResponseUsingStream(ctx, msg);
            } else {
                logger.info((Object)"stop stream");
                this.stopStream(ctx, msg);
            }
        } else {
            DoipMessage response = this.requestHandler.onRequest(msg);
            if (response != null) {
                this.sendResponse(ctx, msg, response);
            } else {
                this.defaultHandler(ctx, msg);
            }
        }
    }

    private void sendResponseUsingStream(ChannelHandlerContext ctx, DoipMessage request) {
        PushFileStream pfs = new PushFileStream(ctx, request);
        pfs.start();
        this.clientMap.put(request.requestID, pfs);
    }

    public void channelActive(ChannelHandlerContext ctx) {
    }

    public void defaultHandler(ChannelHandlerContext ctx, DoipMessage request) {
        this.replyStringWithStatus(ctx, request, "Unsupported Operation!", DoipResponseCode.Declined);
    }

    protected void replyStringWithStatus(ChannelHandlerContext ctx, DoipMessage request, String str, DoipResponseCode resp) {
        DoipMessage response = new DoipMessageFactory.DoipMessageBuilder().createResponse(resp, request).setBody(str.getBytes(StandardCharsets.UTF_8)).create();
        this.sendResponse(ctx, request, response);
    }

    private void sendResponse(ChannelHandlerContext ctx, DoipMessage request, DoipMessage response) {
        logger.debug((Object)("body length: " + response.body.getLength()));
        if (request.getSender() != null) {
            response.setSender(request.getSender());
        }
        if (!ctx.channel().isWritable()) {
            Thread.yield();
            logger.info((Object)"network busy, yeild");
        }
        ctx.writeAndFlush((Object)response);
    }

    private void stopStream(ChannelHandlerContext ctx, DoipMessage msg) {
        logger.info((Object)"stop stream: ");
        this.clientMap.get(msg.requestID).tryToStop();
        this.clientMap.remove(msg.requestID);
        this.replyStringWithStatus(ctx, msg, "stopped", DoipResponseCode.Success);
    }

    private class PushFileStream
    extends Thread {
        ChannelHandlerContext ctx;
        DoipMessage request;
        boolean running = true;

        PushFileStream(ChannelHandlerContext ctx, DoipMessage msg) {
            this.ctx = ctx;
            this.request = msg;
        }

        @Override
        public void run() {
            while (this.running) {
                DoipMessage resp = NettyServerHandler.this.requestHandler.onRequest(this.request);
                if (!this.ctx.channel().isActive()) {
                    logger.warn((Object)"channel inactive");
                    return;
                }
                NettyServerHandler.this.sendResponse(this.ctx, this.request, resp);
                try {
                    PushFileStream.sleep(NettyServerHandler.this.streamPushInterval);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        public void tryToStop() {
            this.running = false;
        }
    }
}

