/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.v2_0;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import org.apache.log4j.Logger;
import org.bdware.doip.codec.v2_0.Delimiters;
import org.bdware.doip.codec.v2_0.DoipMessageCodec;
import org.bdware.doip.endpoint.client.NettyDoipClientChannel;
import org.bdware.doip.endpoint.client.NettyDoipClientHandler;

public class DOIPV2ClientChannel
extends NettyDoipClientChannel {
    static Logger LOGGER = Logger.getLogger(DOIPV2ClientChannel.class);
    final Bootstrap b = new Bootstrap();
    static EventLoopGroup group;
    private final TrustManager[] trustManagers;

    public DOIPV2ClientChannel(TrustManager[] trustManagers) {
        this.trustManagers = trustManagers;
    }

    @Override
    public void close() {
        if (this.handler != null) {
            this.handler.close();
        }
        this.isConnected = false;
    }

    @Override
    public void connect(String targetUrl) throws URISyntaxException {
        URI uri = new URI(targetUrl);
        LOGGER.debug((Object)("[URI Parse]scheme:" + uri.getScheme() + "  host: " + uri.getHost() + "  port: " + uri.getPort()));
        if (group == null) {
            group = new NioEventLoopGroup();
        }
        this.b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)5000);
        this.b.option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(0x100000, 0x1400000));
        this.b.group(group);
        this.handler = new NettyDoipClientHandler();
        final int maxFrameLength = 0x500000;
        ((Bootstrap)((Bootstrap)this.b.channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                ChannelPipeline p = ch.pipeline();
                SSLEngine engine = null;
                try {
                    SSLContext clientContext = SSLContext.getInstance("TLS");
                    clientContext.init(null, DOIPV2ClientChannel.this.trustManagers, null);
                    engine = clientContext.createSSLEngine();
                    engine.setUseClientMode(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                p.addFirst("ssl", (ChannelHandler)new SslHandler(engine)).addLast(new ChannelHandler[]{new DelimiterBasedFrameDecoder(maxFrameLength, Unpooled.copiedBuffer((byte[])Delimiters.EOF))}).addLast(new ChannelHandler[]{new DoipMessageCodec()}).addLast(new ChannelHandler[]{DOIPV2ClientChannel.this.handler});
            }
        });
        LOGGER.info((Object)"[DoipClient] Create TCP Client!");
        try {
            LOGGER.debug((Object)("[URI Parse]host: " + uri.getHost() + "  port: " + uri.getPort()));
            this.channel = this.b.connect(uri.getHost(), uri.getPort()).sync().channel();
            this.handler.setChannel(this.channel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.isConnected = true;
    }

    protected SslContext getSSLContext(File chainFile, File keyFile) throws IllegalStateException {
        try {
            SslContext sslContext = SslContextBuilder.forServer((File)chainFile, (File)keyFile).ciphers(null, (ciphers, defaultCiphers, supportedCiphers) -> (String[])defaultCiphers.stream().filter(x -> null != x && !x.contains("RC4")).toArray(String[]::new)).build();
            return sslContext;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

