/*
 *    Copyright (c) [2021] [Peking University]
 *    [BDWare DOIP SDK] is licensed under Mulan PSL v2.
 *    You can use this software according to the terms and conditions of the Mulan PSL v2.
 *    You may obtain a copy of Mulan PSL v2 at:
 *             http://license.coscl.org.cn/MulanPSL2
 *    THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 *    See the Mulan PSL v2 for more details.
 */

package org.bdware.doip.endpoint.client;

import org.bdware.doip.codec.DOIPVersion;

import java.net.URI;
import java.net.URISyntaxException;

public class ClientConfig {
    public String url;
    public String protocolVersion;

    public ClientConfig(String url) {
        this(url, DOIPVersion.V2_1);
    }

    public ClientConfig(String url, String protocolVersion) {
        this.url = url;
        this.protocolVersion = protocolVersion;
    }
    public static ClientConfig fromUrl(String url){
        return fromUrl(url, DOIPVersion.V2_1);
    }
    public static ClientConfig fromUrl(String url, String protocolVersion) {
        URI uri = null;
        try {
            uri = new URI(url);
            if (uri.getScheme().toLowerCase().equals("tls")) {
                ClientConfig ret = TLSClientConfig.getDefault(url);
                ret.protocolVersion = protocolVersion;
                return ret;
            }

        } catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return new ClientConfig(url, protocolVersion);
    }
}
