/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.codec.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.bdware.doip.codec.digitalObject.DoType;
import org.bdware.doip.codec.doipMessage.DoipResponseCode;

public class DoipGson {
    private static Gson gson;

    public static Gson getDoipGson() {
        if (gson == null) {
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.registerTypeAdapter(DoType.class, (Object)new Json4DoType());
            gsonBuilder.registerTypeAdapter(DoipResponseCode.class, (Object)new Json4DoResponseCode());
            gson = gsonBuilder.create();
            return gson;
        }
        return gson;
    }

    static class Json4DoResponseCode
    implements JsonSerializer<DoipResponseCode>,
    JsonDeserializer<DoipResponseCode> {
        Json4DoResponseCode() {
        }

        public JsonElement serialize(DoipResponseCode type, Type arg1, JsonSerializationContext arg2) {
            return new JsonPrimitive(type.getName());
        }

        public DoipResponseCode deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            for (DoipResponseCode t : DoipResponseCode.values()) {
                if (!t.getName().equals(json.getAsString())) continue;
                return t;
            }
            return DoipResponseCode.MoreThanOneErrors;
        }
    }

    static class Json4DoType
    implements JsonSerializer<DoType>,
    JsonDeserializer<DoType> {
        Json4DoType() {
        }

        public JsonElement serialize(DoType type, Type arg1, JsonSerializationContext arg2) {
            return new JsonPrimitive(type.getName());
        }

        public DoType deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            for (DoType t : DoType.values()) {
                if (!t.getName().equals(json.getAsString())) continue;
                return t;
            }
            return DoType.UnKnown;
        }
    }
}

