/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.client;

import io.netty.util.HashedWheelTimer;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.codec.doipMessage.DoipMessage;
import org.bdware.doip.endpoint.client.DoipMessageCallback;

public class ResponseWait {
    static Logger LOGGER = LogManager.getLogger(ResponseWait.class);
    public static final HashedWheelTimer HASHED_WHEEL_TIMER = new HashedWheelTimer(Executors.defaultThreadFactory(), 5L, TimeUnit.MILLISECONDS, 2);
    static final Map<Integer, DoipMessageCallback> waitObj = new ConcurrentSkipListMap<Integer, DoipMessageCallback>();

    public void wakeUpAndRemove(int requestID, DoipMessage result) {
        DoipMessageCallback ob = this.getAndRemove(requestID);
        this.wakeup(requestID, ob, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DoipMessageCallback getAndRemove(int requestID) {
        Map<Integer, DoipMessageCallback> map = waitObj;
        synchronized (map) {
            DoipMessageCallback ob = waitObj.get(requestID);
            waitObj.remove(requestID);
            return ob;
        }
    }

    public boolean waitResponse(int requestID, DoipMessageCallback cb) {
        return this.waitResponse(requestID, cb, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitResponse(int requestID, DoipMessageCallback cb, int seconds) {
        if (waitObj.size() > 1000) {
            return false;
        }
        Map<Integer, DoipMessageCallback> map = waitObj;
        synchronized (map) {
            if (!waitObj.containsKey(requestID)) {
                waitObj.put(requestID, cb);
                return true;
            }
            LOGGER.info("Return false, try again!");
            return false;
        }
    }

    public void wakeup(int requestID, DoipMessage result) {
        DoipMessageCallback ob = waitObj.get(requestID);
        this.wakeup(requestID, ob, result);
    }

    public void wakeup(int requestID, DoipMessageCallback ob, DoipMessage result) {
        if (ob == null) {
            // empty if block
        }
        if (ob != null) {
            ob.onResult(result);
        }
    }
}

