/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.codec.MessageEnvelopeAggregator;
import org.bdware.doip.codec.MessageEnvelopeCodec;
import org.bdware.doip.endpoint.server.NettyDoipListener;

public class NettyTCPDoipListener
extends NettyDoipListener {
    private final int port;
    static Logger logger = LogManager.getLogger(NettyTCPDoipListener.class);
    private Channel ch;

    public NettyTCPDoipListener(int port) {
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.handler == null) {
            logger.error("Handler not init yet! set handler first");
            return;
        }
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        final int maxFrame = 0x500000;
        try {
            ServerBootstrap b = new ServerBootstrap();
            b.option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(2 * maxFrame, 10 * maxFrame));
            ((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).localAddress(this.port);
            b.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(maxFrame, 20, 4, 0, 0)}).addLast(new ChannelHandler[]{new MessageEnvelopeCodec()}).addLast(new ChannelHandler[]{new MessageEnvelopeAggregator(maxFrame - 24)}).addLast(new ChannelHandler[]{NettyTCPDoipListener.this.handler});
                }
            });
            this.ch = b.bind().syncUninterruptibly().channel();
            logger.info("TCP DOIP listener start at:" + this.port);
            this.ch.closeFuture().sync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            bossGroup.shutdownGracefully();
        }
    }

    @Override
    public void stop() {
        this.ch.close();
    }
}

