/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.codec.MessageEnvelopeCodec;
import org.bdware.doip.codec.NaiveEnvelopeToDoMessage;
import org.bdware.doip.codec.WebSocketFrameToByteBufCodec;
import org.bdware.doip.endpoint.server.NettyDoipListener;
import org.bdware.doip.endpoint.server.NettyTCPDoipListener;

public class NettyWSDoipListener
extends NettyDoipListener {
    private final int port;
    private final String path;
    static Logger logger = LogManager.getLogger(NettyTCPDoipListener.class);
    private Channel ch;

    public NettyWSDoipListener(int port, String path) {
        this.port = port;
        this.path = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.handler == null) {
            logger.error("Handler not init yet! set handler first");
            return;
        }
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).localAddress(this.port);
            b.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new HttpServerCodec()}).addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)}).addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler(NettyWSDoipListener.this.path, null, true)}).addLast(new ChannelHandler[]{new WebSocketFrameToByteBufCodec()}).addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(65536, 20, 4, 0, 0)}).addLast(new ChannelHandler[]{new MessageEnvelopeCodec()}).addLast(new ChannelHandler[]{new NaiveEnvelopeToDoMessage()}).addLast(new ChannelHandler[]{NettyWSDoipListener.this.handler});
                }
            });
            this.ch = b.bind().syncUninterruptibly().channel();
            logger.info("WS DOIP listener start at:" + this.port + this.path);
            this.ch.closeFuture().sync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            bossGroup.shutdownGracefully();
        }
    }

    @Override
    public void stop() {
        this.ch.close();
    }
}

