/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.codec.digitalObject;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bdware.doip.codec.digitalObject.DoType;
import org.bdware.doip.codec.digitalObject.Element;
import org.bdware.doip.codec.exception.DoDecodeException;
import org.bdware.doip.codec.utils.DoipGson;

public class DigitalObject {
    public String id;
    public DoType type;
    public JsonObject attributes;
    public List<Element> elements;
    static final String UUID_KEY = "UUID";

    public DigitalObject(String id, DoType type) {
        this.id = id;
        this.type = type;
    }

    public void setAttributes(JsonObject data) {
        this.attributes = data;
    }

    public void addAttribute(String name, String att) {
        if (this.attributes == null) {
            this.attributes = new JsonObject();
        }
        this.attributes.addProperty(name, att);
    }

    public UUID getUUID() {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.has(UUID_KEY) ? UUID.fromString(this.attributes.get(UUID_KEY).getAsString()) : null;
    }

    public void setUUID(UUID uuid) {
        this.addAttribute(UUID_KEY, uuid.toString());
    }

    public void addAttribute(String name, Number att) {
        if (this.attributes == null) {
            this.attributes = new JsonObject();
        }
        this.attributes.addProperty(name, att);
    }

    public void addAttribute(String name, JsonElement att) {
        if (this.attributes == null) {
            this.attributes = new JsonObject();
        }
        this.attributes.add(name, att);
    }

    public void addElements(Element e) {
        if (this.elements == null) {
            this.elements = new ArrayList<Element>();
        }
        this.elements.add(e);
    }

    public boolean isSigned() {
        return this.attributes != null && this.attributes.has("isSigned");
    }

    public String toString() {
        if (this.elements != null) {
            for (Element e : this.elements) {
                if (e.getData() == null) continue;
                e.dataString = new String(e.getData());
            }
        }
        return new Gson().toJson((Object)this);
    }

    public void needSign() {
        this.addAttribute("isSigned", "true");
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bo);
        Gson gson = DoipGson.getDoipGson();
        String jsonSegments = gson.toJson((Object)this);
        try {
            out.writeInt(jsonSegments.getBytes(StandardCharsets.UTF_8).length);
            out.write(jsonSegments.getBytes(StandardCharsets.UTF_8));
            if (this.elements != null) {
                for (Element e : this.elements) {
                    if (e.getData() == null) continue;
                    assert (e.length == e.getData().length);
                    out.write(e.getData());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bo.toByteArray();
    }

    public static DigitalObject fromByteArray(byte[] doBytes) throws DoDecodeException, IOException {
        if (doBytes == null || doBytes.length == 0) {
            return null;
        }
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(doBytes));
        int metaLen = input.readInt();
        if (metaLen > doBytes.length) {
            throw new DoDecodeException("invalid DO byte array");
        }
        byte[] content = new byte[metaLen];
        int eof = input.read(content);
        Gson gson = DoipGson.getDoipGson();
        DigitalObject d = (DigitalObject)gson.fromJson(new String(content), DigitalObject.class);
        if (d.elements == null || eof == -1 || input.available() == 0) {
            return d;
        }
        for (int i = 0; i < d.elements.size(); ++i) {
            if (input.available() < d.elements.get((int)i).length) {
                throw new DoDecodeException("Unexpected element data length");
            }
            byte[] data = new byte[d.elements.get((int)i).length];
            input.read(data);
            d.elements.get(i).setData(data);
        }
        return d;
    }
}

