/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import org.bdware.doip.codec.MessageEnvelopeAggregator;
import org.bdware.doip.codec.MessageEnvelopeCodec;
import org.bdware.doip.endpoint.client.NettyDoipClientChannel;
import org.bdware.doip.endpoint.client.NettyDoipClientHandler;

public class NettyDoipTLSClientChannel
extends NettyDoipClientChannel {
    final Bootstrap b = new Bootstrap();
    static EventLoopGroup group;
    private final TrustManager[] trustManagers;

    public NettyDoipTLSClientChannel(TrustManager[] trustManagers) {
        this.trustManagers = trustManagers;
    }

    @Override
    public void close() {
        if (this.handler != null) {
            this.handler.close();
        }
        this.isConnected = false;
    }

    @Override
    public void connect(String targetUrl) throws URISyntaxException {
        URI uri = new URI(targetUrl);
        logger.debug("[URI Parse]scheme:" + uri.getScheme() + "  host: " + uri.getHost() + "  port: " + uri.getPort());
        if (group == null) {
            group = new NioEventLoopGroup();
        }
        this.b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)5000);
        this.b.option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(0x100000, 0x1400000));
        this.b.group(group);
        this.handler = new NettyDoipClientHandler();
        ((Bootstrap)((Bootstrap)this.b.channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                ChannelPipeline p = ch.pipeline();
                SSLEngine engine = null;
                try {
                    SSLContext clientContext = SSLContext.getInstance("TLS");
                    clientContext.init(null, NettyDoipTLSClientChannel.this.trustManagers, null);
                    engine = clientContext.createSSLEngine();
                    engine.setUseClientMode(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                p.addFirst("ssl", (ChannelHandler)new SslHandler(engine)).addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(0x500000, 20, 4, 0, 0)}).addLast(new ChannelHandler[]{new MessageEnvelopeCodec()}).addLast(new ChannelHandler[]{new MessageEnvelopeAggregator()}).addLast(new ChannelHandler[]{NettyDoipTLSClientChannel.this.handler});
            }
        });
        logger.info("[DoipClient] Create TCP Client!");
        try {
            logger.debug("[URI Parse]host: " + uri.getHost() + "  port: " + uri.getPort());
            this.channel = this.b.connect(uri.getHost(), uri.getPort()).sync().channel();
            this.handler.setChannel(this.channel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.isConnected = true;
    }

    protected SslContext getSSLContext(File chainFile, File keyFile) throws IllegalStateException {
        try {
            SslContext sslContext = SslContextBuilder.forServer((File)chainFile, (File)keyFile).ciphers(null, (ciphers, defaultCiphers, supportedCiphers) -> (String[])defaultCiphers.stream().filter(x -> null != x && !x.contains("RC4")).toArray(String[]::new)).build();
            return sslContext;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

