/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.codec.doipMessage;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.bdware.doip.codec.digitalObject.DigitalObject;
import org.bdware.doip.codec.exception.DoDecodeException;

public class MessageBody {
    public byte[] encodedData = new byte[0];

    public int getLength() {
        return this.encodedData.length;
    }

    public void setDataAsDigitalObject(DigitalObject digitalObject) {
        this.encodedData = digitalObject.toByteArray();
    }

    public DigitalObject getDataAsDigitalObject() throws DoDecodeException, IOException {
        return DigitalObject.fromByteArray(this.encodedData);
    }

    public String getDataAsJsonString() {
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(this.encodedData));
        int metaLen = 0;
        try {
            metaLen = input.readInt();
            if (metaLen != input.available()) {
                input.reset();
                metaLen = input.available();
            }
            byte[] content = new byte[metaLen];
            input.read(content);
            return new String(content);
        }
        catch (Exception e) {
            return new String(this.encodedData);
        }
    }

    public byte[] getEncodedData() {
        return this.encodedData;
    }
}

