/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bdware.doip.codec.digitalObject.DigitalObject;
import org.bdware.doip.codec.digitalObject.DoType;
import org.bdware.doip.codec.digitalObject.Element;

public class DoExample {
    public static DigitalObject small = DoExample.getDo("bdware.test/small", 1, 20, true);
    public static DigitalObject large = DoExample.getDo("bdware.test/large", 200, 5000, true);
    public static DigitalObject noData = DoExample.getDo("bdware.test/small", 1, 20, false);
    public static DigitalObject b2000 = DoExample.getDo("bdware.test/large", 2, 1000, true);
    public static DigitalObject superLarge = DoExample.getDo("bdware.test/large", 2000, 1000, true);

    private static DigitalObject getDo(String doid, int num, int dataSize, boolean withData) {
        DigitalObject digitalObject = new DigitalObject("doid", DoType.DO);
        digitalObject.addAttribute("random", "attr");
        digitalObject.addAttribute("another", 52);
        if (withData) {
            DoExample.makeTestElements(num, dataSize).forEach(digitalObject::addElements);
        }
        return digitalObject;
    }

    static List<Element> makeTestElementsWithoutData(List<Element> es) {
        ArrayList<Element> es2 = new ArrayList<Element>();
        Random rand = new Random();
        es.forEach(e -> {
            Element e2 = new Element(e.id, e.type);
            e2.length = e.length;
            e2.attributes = e.attributes;
            es2.add(e2);
        });
        return es2;
    }

    static List<Element> makeTestElements(int num, int dataSize) {
        ArrayList<Element> es = new ArrayList<Element>();
        Random rand = new Random();
        for (int i = 0; i < num; ++i) {
            Element e = DoExample.makeTestElement(dataSize);
            es.add(e);
        }
        return es;
    }

    static Element makeTestElement(int dataSize) {
        Element e = new Element("file", "application/pdf");
        byte[] data = new byte[dataSize];
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < dataSize; ++i) {
            sb.append(Math.abs(new Random().nextInt()) % 10);
        }
        System.arraycopy(sb.toString().getBytes(StandardCharsets.UTF_8), 0, data, 0, dataSize);
        System.arraycopy("cold ".getBytes(StandardCharsets.UTF_8), 0, data, 0, "cold ".getBytes(StandardCharsets.UTF_8).length);
        e.setData(data);
        e.setAttribute("random", "attr");
        e.setAttribute("size", String.valueOf(dataSize));
        return e;
    }
}

