/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import java.net.URI;
import java.net.URISyntaxException;
import org.bdware.doip.codec.MessageEnvelopeAggregator;
import org.bdware.doip.codec.MessageEnvelopeCodec;
import org.bdware.doip.endpoint.client.NettyDoipClientChannel;
import org.bdware.doip.endpoint.client.NettyDoipClientHandler;

public class NettyDoipTCPClientChannel
extends NettyDoipClientChannel {
    final Bootstrap b;
    static EventLoopGroup group;
    boolean splitEnvelop;
    int maxFrameLength;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NettyDoipTCPClientChannel(boolean splitEnvelop, final int maxFrameLength) {
        this.splitEnvelop = splitEnvelop;
        this.maxFrameLength = maxFrameLength;
        this.b = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)this.b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)5000)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.SO_LINGER, (Object)0);
        this.b.option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(2 * maxFrameLength, 10 * maxFrameLength));
        Class<NettyDoipTCPClientChannel> clazz = NettyDoipTCPClientChannel.class;
        synchronized (NettyDoipTCPClientChannel.class) {
            if (group == null) {
                group = new NioEventLoopGroup();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.b.group(group);
            this.handler = new NettyDoipClientHandler();
            ((Bootstrap)((Bootstrap)this.b.channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(maxFrameLength, 20, 4, 0, 0)}).addLast(new ChannelHandler[]{new MessageEnvelopeCodec()});
                    p.addLast(new ChannelHandler[]{new MessageEnvelopeAggregator(maxFrameLength - 24)});
                    p.addLast(new ChannelHandler[]{NettyDoipTCPClientChannel.this.handler});
                }
            });
            return;
        }
    }

    public NettyDoipTCPClientChannel() {
        this(false, 0x500000);
    }

    @Override
    public void close() {
        if (this.handler != null) {
            this.handler.close();
        }
        try {
            if (this.channel != null) {
                this.channel.unsafe().closeForcibly();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isConnected = false;
    }

    @Override
    public void connect(String targetUrl) throws URISyntaxException, InterruptedException {
        URI uri = new URI(targetUrl);
        logger.debug("[URI Parse]scheme:" + uri.getScheme() + "  host: " + uri.getHost() + "  port: " + uri.getPort());
        logger.info("[DoipClient] Create TCP Client!");
        logger.debug("[URI Parse]host: " + uri.getHost() + "  port: " + uri.getPort());
        this.channel = this.b.connect(uri.getHost(), uri.getPort()).sync().channel();
        this.handler.setChannel(this.channel);
        this.isConnected = true;
    }
}

